/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.execution.ExecutionIdGenerator;

public class PipelineContext {
    private String executionId;
    private final Iterator<Stage> iterator;
    private final Pipeline pipeline;
    private Optional<Object> lastOutput = Optional.empty();
    private Optional<Stage<Object, ?>> currentStage = Optional.empty();
    private Map<String, Object> values = new HashMap<String, Object>();
    private final Deque<Consumer<?>> callbacks = new LinkedList();

    Optional<Object> pollOutput() {
        return this.lastOutput;
    }

    PipelineContext(Pipeline pipeline) {
        this.pipeline = pipeline;
        this.iterator = pipeline.getStages().iterator();
    }

    public String getExecutionId() {
        return this.executionId;
    }

    void pushOutput(String id, Object value) {
        this.lastOutput = Optional.of(value);
        this.values.put(id, value);
        this.currentStage = this.iterator.hasNext() ? Optional.of(this.iterator.next()) : Optional.empty();
    }

    void start(Object initialInput) {
        if (this.isStarted()) {
            throw new RuntimeException("Process has already been started.");
        }
        this.values.put("input", initialInput);
        this.executionId = initialInput instanceof Input ? ((Input)initialInput).computeIfAbsent("_pipelineExecutionId_", generator -> ExecutionIdGenerator.generateExecutionId()) : ExecutionIdGenerator.generateExecutionId();
        this.currentStage = this.iterator.hasNext() ? Optional.of(this.iterator.next()) : Optional.empty();
        this.lastOutput = Optional.of(initialInput);
    }

    boolean isStarted() {
        return this.currentStage.isPresent() || this.lastOutput.isPresent();
    }

    boolean isFinished() {
        return !this.currentStage.isPresent() && this.lastOutput.isPresent();
    }

    Optional<Stage<Object, ?>> getCurrentStage() {
        return this.currentStage;
    }

    void pushCallback(Consumer<?> callback) {
        this.callbacks.push(callback);
    }

    boolean hasCallbacks() {
        return !this.callbacks.isEmpty();
    }

    void applyCallbackAndPop(Object value) {
        Consumer<?> callback = this.callbacks.peek();
        callback.accept(value);
        this.callbacks.pop();
    }

    Pipeline getPipeline() {
        return this.pipeline;
    }

    Map<String, Object> getValues() {
        return this.values;
    }
}

