/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.ContributorType;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.util.URIUtil;

public class SpaceConfigStorageImpl
implements SpaceConfigStorage {
    public static final String FILE_FORMAT = ".json";
    public static final String BRANCH_PERMISSIONS = "BranchPermissions";
    public static final String SPACE_INFO = "SpaceInfo";
    private static final String CHANGE_REQUESTS_FOLDER = "change_requests";
    private static final String CHANGE_REQUESTS_FILE = "information.cr";
    private static final String CHANGE_REQUEST_COMMENTS_FOLDER = "comments";
    private static final String CHANGE_REQUEST_COMMENT_FILE_EXT = "comment";
    private static final Logger logger = LoggerFactory.getLogger(SpaceConfigStorageImpl.class);
    private ObjectStorage objectStorage;
    private IOService ioService;
    private String spaceName;

    public SpaceConfigStorageImpl() {
    }

    @Inject
    public SpaceConfigStorageImpl(ObjectStorage objectStorage, @Named(value="configIO") IOService ioService) {
        this.objectStorage = objectStorage;
        this.ioService = ioService;
    }

    public void setup(String spaceName) {
        this.spaceName = spaceName;
        this.objectStorage.init(this.getRootURI(spaceName));
    }

    public BranchPermissions loadBranchPermissions(String branchName, String projectIdentifier) {
        BranchPermissions branchPermissions = (BranchPermissions)this.objectStorage.read(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
        if (branchPermissions == null) {
            return this.getDefaultBranchPermissions(branchName);
        }
        return branchPermissions;
    }

    private URI getRootURI(String spaceName) {
        return URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)spaceName));
    }

    public void saveBranchPermissions(String branchName, String projectIdentifier, BranchPermissions branchPermissions) {
        this.objectStorage.write(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS), (Object)branchPermissions);
    }

    public void deleteBranchPermissions(String branchName, String projectIdentifier) {
        this.objectStorage.delete(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
    }

    public void deleteRepository(String repositoryAlias) {
        this.deleteAllChangeRequests(repositoryAlias);
        this.objectStorage.delete(this.buildRepositoryFolderPath(repositoryAlias));
    }

    public List<ChangeRequest> loadChangeRequests(String repositoryAlias) {
        return this.getChangeRequestIds(repositoryAlias).stream().map(changeRequestId -> this.loadChangeRequest(repositoryAlias, (Long)changeRequestId)).collect(Collectors.toList());
    }

    public ChangeRequest loadChangeRequest(String repositoryAlias, Long changeRequestId) {
        return (ChangeRequest)this.objectStorage.read(this.buildChangeRequestFilePath(repositoryAlias, changeRequestId));
    }

    public void saveChangeRequest(String repositoryAlias, ChangeRequest changeRequest) {
        this.objectStorage.write(this.buildChangeRequestFilePath(repositoryAlias, changeRequest.getId()), (Object)changeRequest);
    }

    public void deleteAllChangeRequests(String repositoryAlias) {
        this.getChangeRequestIds(repositoryAlias).forEach(changeRequestId -> this.deleteChangeRequest(repositoryAlias, (Long)changeRequestId));
    }

    public void deleteChangeRequest(String repositoryAlias, Long changeRequestId) {
        this.deleteAllChangeRequestComments(repositoryAlias, changeRequestId);
        this.objectStorage.delete(this.buildChangeRequestFilePath(repositoryAlias, changeRequestId));
    }

    public List<Long> getChangeRequestIds(String repositoryAlias) {
        ArrayList<Long> changeRequestIds = new ArrayList<Long>();
        String changeRequestsFolderPath = this.buildChangeRequestsFolderPath(repositoryAlias);
        if (this.objectStorage.exists(changeRequestsFolderPath)) {
            Path changeRequestsFolder = this.objectStorage.getPath(changeRequestsFolderPath, new String[0]);
            try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(changeRequestsFolder, x$0 -> Files.isDirectory((Path)x$0, (LinkOption[])new LinkOption[0]));){
                directoryStream.forEach(crDir -> {
                    try {
                        Long id = Long.valueOf(crDir.getFileName().toString());
                        changeRequestIds.add(id);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Cannot convert folder name to long: ", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error("An unexpected exception was thrown: ", (Throwable)e);
                    }
                });
            }
        }
        return changeRequestIds;
    }

    public List<ChangeRequestComment> loadChangeRequestComments(String repositoryAlias, Long changeRequestId) {
        return this.getChangeRequestCommentIds(repositoryAlias, changeRequestId).stream().map(changeRequestCommentId -> this.loadChangeRequestComment(repositoryAlias, changeRequestId, (Long)changeRequestCommentId)).collect(Collectors.toList());
    }

    public ChangeRequestComment loadChangeRequestComment(String repositoryAlias, Long changeRequestId, Long changeRequestCommentId) {
        return (ChangeRequestComment)this.objectStorage.read(this.buildChangeRequestCommentFilePath(repositoryAlias, changeRequestId, changeRequestCommentId));
    }

    public void saveChangeRequestComment(String repositoryAlias, Long changeRequestId, ChangeRequestComment changeRequestComment) {
        this.objectStorage.write(this.buildChangeRequestCommentFilePath(repositoryAlias, changeRequestId, changeRequestComment.getId()), (Object)changeRequestComment);
    }

    public void deleteAllChangeRequestComments(String repositoryAlias, Long changeRequestId) {
        this.getChangeRequestCommentIds(repositoryAlias, changeRequestId).forEach(changeRequestCommentId -> this.deleteChangeRequestComment(repositoryAlias, changeRequestId, (Long)changeRequestCommentId));
    }

    public void deleteChangeRequestComment(String repositoryAlias, Long changeRequestId, Long changeRequestCommentId) {
        this.objectStorage.delete(this.buildChangeRequestCommentFilePath(repositoryAlias, changeRequestId, changeRequestCommentId));
    }

    public List<Long> getChangeRequestCommentIds(String repositoryAlias, Long changeRequestId) {
        ArrayList<Long> changeRequestCommentIds = new ArrayList<Long>();
        String changeRequestCommentsPathStr = this.buildChangeRequestCommentFolderPath(repositoryAlias, changeRequestId);
        if (this.objectStorage.exists(changeRequestCommentsPathStr)) {
            Path changeRequestCommentsFolder = this.objectStorage.getPath(changeRequestCommentsPathStr, new String[0]);
            try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(changeRequestCommentsFolder, x$0 -> Files.isRegularFile((Path)x$0, (LinkOption[])new LinkOption[0]));){
                directoryStream.forEach(commentFile -> {
                    try {
                        Long id = Long.valueOf(FilenameUtils.getBaseName((String)commentFile.getFileName().toString()));
                        changeRequestCommentIds.add(id);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Cannot convert folder name to long: ", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error("An unexpected exception was thrown: ", (Throwable)e);
                    }
                });
            }
        }
        return changeRequestCommentIds;
    }

    BranchPermissions getDefaultBranchPermissions(String branchName) {
        LinkedHashMap<String, RolePermissions> defaultPermissions = new LinkedHashMap<String, RolePermissions>();
        defaultPermissions.put(ContributorType.OWNER.name(), new RolePermissions(ContributorType.OWNER.name(), true, true, true, true));
        defaultPermissions.put(ContributorType.ADMIN.name(), new RolePermissions(ContributorType.ADMIN.name(), true, true, false, true));
        defaultPermissions.put(ContributorType.CONTRIBUTOR.name(), new RolePermissions(ContributorType.CONTRIBUTOR.name(), true, true, false, false));
        return new BranchPermissions(branchName, defaultPermissions);
    }

    public SpaceInfo loadSpaceInfo() {
        return (SpaceInfo)this.objectStorage.read(this.buildSpaceConfigFilePath(SPACE_INFO));
    }

    public void saveSpaceInfo(SpaceInfo spaceInfo) {
        this.objectStorage.write(this.buildSpaceConfigFilePath(SPACE_INFO), (Object)spaceInfo, false);
    }

    public void startBatch() {
        this.ioService.startBatch(this.ioService.get(this.getRootURI(this.spaceName)).getFileSystem());
    }

    public void endBatch() {
        this.ioService.endBatch();
    }

    public void close() {
        this.objectStorage.close();
    }

    public boolean isInitialized() {
        return this.loadSpaceInfo() != null;
    }

    String buildSpaceConfigFilePath(String configName) {
        return "/config/" + configName + FILE_FORMAT;
    }

    String buildProjectConfigFilePath(String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + configName + FILE_FORMAT;
    }

    String buildBranchConfigFilePath(String branchName, String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + this.encode(branchName) + "/" + configName + FILE_FORMAT;
    }

    private String buildRepositoryFolderPath(String repositoryAlias) {
        return String.format("/%s", this.encode(repositoryAlias));
    }

    private String buildChangeRequestsFolderPath(String repositoryAlias) {
        return String.format("%s/%s", this.buildRepositoryFolderPath(repositoryAlias), CHANGE_REQUESTS_FOLDER);
    }

    private String buildChangeRequestFilePath(String repositoryAlias, Long changeRequestId) {
        return String.format("%s/%s/%s", this.buildChangeRequestsFolderPath(repositoryAlias), changeRequestId, CHANGE_REQUESTS_FILE);
    }

    private String buildChangeRequestCommentFolderPath(String repositoryAlias, Long changeRequestId) {
        return String.format("%s/%s/%s", this.buildChangeRequestsFolderPath(repositoryAlias), changeRequestId, CHANGE_REQUEST_COMMENTS_FOLDER);
    }

    private String buildChangeRequestCommentFilePath(String repositoryAlias, Long changeRequestId, Long changeRequestCommentId) {
        return String.format("%s/%s.%s", this.buildChangeRequestCommentFolderPath(repositoryAlias, changeRequestId), changeRequestCommentId, CHANGE_REQUEST_COMMENT_FILE_EXT);
    }

    private String encode(String text) {
        return URIUtil.encodeQueryString((String)text);
    }

    public Path getPath() {
        URI configPathURI = this.getConfigPathUri();
        return this.ioService.get(configPathURI);
    }

    private URI getConfigPathUri() {
        return URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)this.spaceName));
    }
}

