/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.BooleanMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.CharacterMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DateMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DecimalMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.IntegerMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.StringMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.adapters.fields.AbstractFieldAdapter;
import org.kie.workbench.common.forms.model.FieldDefinition;

public class MultiplesValuesAdapter
extends AbstractFieldAdapter {
    private Map<String, Supplier<FieldDefinition>> suppliers = new HashMap<String, Supplier<FieldDefinition>>();

    public MultiplesValuesAdapter() {
        this.suppliers.put(Boolean.class.getName(), BooleanMultipleInputFieldDefinition::new);
        this.suppliers.put(Character.class.getName(), CharacterMultipleInputFieldDefinition::new);
        this.suppliers.put(String.class.getName(), StringMultipleInputFieldDefinition::new);
        this.suppliers.put(BigInteger.class.getName(), IntegerMultipleInputFieldDefinition::new);
        this.suppliers.put(Byte.class.getName(), IntegerMultipleInputFieldDefinition::new);
        this.suppliers.put(Integer.class.getName(), IntegerMultipleInputFieldDefinition::new);
        this.suppliers.put(Long.class.getName(), IntegerMultipleInputFieldDefinition::new);
        this.suppliers.put(Short.class.getName(), IntegerMultipleInputFieldDefinition::new);
        this.suppliers.put(BigDecimal.class.getName(), DecimalMultipleInputFieldDefinition::new);
        this.suppliers.put(Double.class.getName(), DecimalMultipleInputFieldDefinition::new);
        this.suppliers.put(Float.class.getName(), DecimalMultipleInputFieldDefinition::new);
        this.suppliers.put(Date.class.getName(), DateMultipleInputFieldDefinition::new);
        this.suppliers.put(LocalDate.class.getName(), DateMultipleInputFieldDefinition::new);
        this.suppliers.put(LocalDateTime.class.getName(), DateMultipleInputFieldDefinition::new);
        this.suppliers.put(LocalTime.class.getName(), DateMultipleInputFieldDefinition::new);
        this.suppliers.put(OffsetDateTime.class.getName(), DateMultipleInputFieldDefinition::new);
    }

    @Override
    protected FieldDefinition getFieldDefinition(Field originalField) {
        Supplier<FieldDefinition> supplier = this.suppliers.get(originalField.getBag());
        if (supplier != null) {
            return supplier.get();
        }
        return null;
    }

    @Override
    public String[] getLegacyFieldTypeCodes() {
        return new String[]{"MultipleInput"};
    }
}

