/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.builder.ResourceChangeObservableFile;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ObservableDRLFile
implements ResourceChangeObservableFile {
    static final String EXTENSION = "drl";
    private static final String REGEX = "^.*declare\\s.+\\send.*$";
    private static final Pattern PATTERN = Pattern.compile("^.*declare\\s.+\\send.*$", 32);
    private IOService ioService;

    public ObservableDRLFile() {
    }

    @Inject
    public ObservableDRLFile(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public boolean accept(org.uberfire.backend.vfs.Path path) {
        try {
            String fileName = path.getFileName();
            if (!fileName.endsWith(".drl")) {
                return false;
            }
            String drl = this.ioService.readAllString(this.convert(path));
            return PATTERN.matcher(drl.toLowerCase()).matches();
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    Path convert(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }
}

