/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class GetCommit {
    private final Git git;
    private final String commitId;

    public GetCommit(Git git, String commitId) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.commitId = PortablePreconditions.checkNotEmpty((String)"commitId", (String)commitId);
    }

    public RevCommit execute() {
        RevCommit revCommit;
        Repository repository = this.git.getRepository();
        RevWalk revWalk = new RevWalk(repository);
        try {
            ObjectId id = repository.resolve(this.commitId);
            revCommit = id != null ? revWalk.parseCommit((AnyObjectId)id) : null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new GitException("Error when trying to get commit", e);
            }
        }
        revWalk.close();
        return revCommit;
    }
}

