/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.ExperimentalFeatureProcessor;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class ExperimentalActivityGenerator
extends AbstractGenerator {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        HashMap<String, String> root = new HashMap<String, String>();
        TypeElement typeElement = (TypeElement)element;
        String featureId = typeElement.getQualifiedName().toString();
        String activityClass = typeElement.getQualifiedName().toString() + "Activity";
        String activityId = this.extractActivityId(typeElement);
        String activityType = ExperimentalFeatureProcessor.getActivityType((TypeElement)element).get();
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Feature Id: " + featureId);
            messager.printMessage(Diagnostic.Kind.NOTE, "Activity class: " + activityClass);
            messager.printMessage(Diagnostic.Kind.NOTE, "Activity Id: " + activityId);
            messager.printMessage(Diagnostic.Kind.NOTE, "Activity Type: " + activityType);
        }
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("featureId", featureId);
        root.put("activityClass", activityClass);
        root.put("activityId", activityId);
        root.put("activityType", activityType);
        try (StringWriter sw = new StringWriter();){
            StringBuffer stringBuffer;
            try (BufferedWriter bw = new BufferedWriter(sw);){
                Template template = config.getTemplate("experimentalFeatureActivity.ftl");
                template.process(root, (Writer)bw);
                messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
                stringBuffer = sw.getBuffer();
            }
            return stringBuffer;
        }
        catch (Exception te) {
            throw new GenerationException(te);
        }
    }

    private String extractActivityId(TypeElement element) {
        Optional<String> optional = this.getOptional(ClientAPIModule.getWbPerspectiveScreenIdentifierValueOnClass(element));
        if (optional.isPresent()) {
            return optional.get();
        }
        return this.getOptional(ClientAPIModule.getWbScreenIdentifierValueOnClass(element)).orElse(ClientAPIModule.getWbEditorIdentifierValueOnClass(element));
    }

    private Optional<String> getOptional(String identifier) {
        return Optional.ofNullable(identifier).map(id -> id.isEmpty() ? null : id);
    }
}

