/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.allowlist;

import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.file.SupportsUpdate;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.services.shared.allowlist.AllowList;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;

public class PackageNameAllowListSaver
implements SupportsUpdate<AllowList> {
    private MetadataServerSideService metadataService;
    private IOService ioService;
    private CommentedOptionFactory commentedOptionFactory;

    public PackageNameAllowListSaver() {
    }

    @Inject
    public PackageNameAllowListSaver(@Named(value="ioStrategy") IOService ioService, MetadataServerSideService metadataService, CommentedOptionFactory commentedOptionFactory) {
        this.ioService = ioService;
        this.metadataService = metadataService;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public Path save(Path path, AllowList content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((Path)path), this.toString(content), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String toString(AllowList content) {
        StringBuilder builder = new StringBuilder();
        for (String line : content) {
            builder.append(line);
            builder.append('\n');
        }
        return builder.toString();
    }
}

