/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.ketch.Proposal;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class RefTreeUpdateCommand {
    private final Git git;
    private final String name;
    private final RevCommit commit;

    public RefTreeUpdateCommand(Git git, String branchName, RevCommit commit) {
        this.git = git;
        this.name = branchName;
        this.commit = commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, ConcurrentRefUpdateException {
        this.update(this.git.getRepository(), "refs/heads/" + this.name, this.commit);
        if (this.name.equals("master") && !this.git.isHEADInitialized()) {
            Repository repository = this.git.getRepository();
            synchronized (repository) {
                this.symRef(this.git, "HEAD", "refs/heads/" + this.name);
                this.git.setHeadAsInitialized();
            }
        }
    }

    private void symRef(Git git, String name, String dst) throws IOException {
        this.commit(git.getRepository(), null, (reader, tree) -> {
            Ref old = tree.exactRef(reader, name);
            Ref newx = tree.exactRef(reader, dst);
            Command n = newx != null ? new Command(old, (Ref)new SymbolicRef(name, newx)) : new Command(old, (Ref)new SymbolicRef(name, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.NEW, dst, null)));
            return tree.apply(Collections.singleton(n));
        });
    }

    private void update(Repository _repo, String _name, RevCommit _commit) throws IOException {
        this.commit(_repo, _commit, (reader, refTree) -> {
            Ref old = refTree.exactRef(reader, _name);
            ArrayList<Command> n = new ArrayList<Command>(1);
            try (RevWalk rw = new RevWalk(_repo);){
                n.add(new Command(old, RefTreeUpdateCommand.toRef(rw, (ObjectId)_commit, _name, true)));
                if (this.git.isKetchEnabled()) {
                    this.proposeKetch(n, _commit);
                }
            }
            catch (IOException | InterruptedException e) {
                String msg = JGitText.get().transactionAborted;
                for (Command cmd : n) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, msg);
                }
                throw new GitException("Error");
            }
            return refTree.apply(n);
        });
    }

    private void proposeKetch(List<Command> n, RevCommit _commit) throws IOException, InterruptedException {
        Proposal proposal = new Proposal(n).setAuthor(_commit.getAuthorIdent()).setMessage("push");
        this.git.getKetchLeader().queueProposal(proposal);
        if (proposal.isDone()) {
            throw new GitException("Error");
        }
        if (proposal.getState() == Proposal.State.QUEUED) {
            this.waitForQueue(proposal);
        }
        if (!proposal.isDone()) {
            this.waitForPropose(proposal);
        }
    }

    private void waitForQueue(Proposal proposal) throws InterruptedException {
        while (!proposal.awaitStateChange(Proposal.State.QUEUED, 250L, TimeUnit.MILLISECONDS)) {
            System.out.println("waiting queue...");
        }
        switch (proposal.getState()) {
            default: {
                break;
            }
            case EXECUTED: {
            }
            case ABORTED: 
        }
    }

    private void waitForPropose(Proposal proposal) throws InterruptedException {
        while (!proposal.await(250L, TimeUnit.MILLISECONDS)) {
            System.out.println("waiting propose...");
        }
    }

    private static Ref toRef(RevWalk rw, ObjectId id, String name, boolean mustExist) throws IOException {
        if (ObjectId.zeroId().equals((AnyObjectId)id)) {
            return null;
        }
        try {
            RevObject o = rw.parseAny((AnyObjectId)id);
            if (o instanceof RevTag) {
                RevObject p = rw.peel(o);
                return new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, id, p.copy());
            }
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id);
        }
        catch (MissingObjectException e) {
            if (mustExist) {
                throw e;
            }
            return new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name, id);
        }
    }

    private void commit(Repository repo, RevCommit original, BiFunction fun) throws IOException {
        try (ObjectReader reader = repo.newObjectReader();
             ObjectInserter inserter = repo.newObjectInserter();
             RevWalk rw = new RevWalk(reader);){
            Ref ref2;
            RefTree tree;
            RefTreeDatabase refdb = (RefTreeDatabase)repo.getRefDatabase();
            RefDatabase bootstrap = refdb.getBootstrap();
            RefUpdate refUpdate = bootstrap.newUpdate(refdb.getTxnCommitted(), false);
            CommitBuilder cb = new CommitBuilder();
            Ref ref = bootstrap.exactRef(refdb.getTxnCommitted());
            if (ref != null && ref.getObjectId() != null) {
                tree = RefTree.read((ObjectReader)reader, (RevTree)rw.parseTree((AnyObjectId)ref.getObjectId()));
                cb.setParentId((AnyObjectId)ref.getObjectId());
                refUpdate.setExpectedOldObjectId((AnyObjectId)ref.getObjectId());
            } else {
                tree = RefTree.newEmptyTree();
                refUpdate.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
            }
            if (fun.apply(reader, tree) && ((ref2 = bootstrap.exactRef(refdb.getTxnCommitted())) == null || ref2.getObjectId().equals((AnyObjectId)(ref != null ? ref.getObjectId() : null)))) {
                cb.setTreeId((AnyObjectId)tree.writeTree(inserter));
                if (original != null) {
                    cb.setAuthor(original.getAuthorIdent());
                    cb.setCommitter(original.getAuthorIdent());
                } else {
                    PersonIdent personIdent = new PersonIdent("user", "user@example.com");
                    cb.setAuthor(personIdent);
                    cb.setCommitter(personIdent);
                }
                refUpdate.setNewObjectId((AnyObjectId)inserter.insert(cb));
                inserter.flush();
                RefUpdate.Result result = refUpdate.update(rw);
                switch (result) {
                    case NEW: 
                    case FAST_FORWARD: {
                        break;
                    }
                    default: {
                        throw new RuntimeException(repo.getDirectory() + " -> " + result.toString() + " : " + refUpdate.getName());
                    }
                }
                File commited = new File(repo.getDirectory(), refdb.getTxnCommitted());
                File accepted = new File(repo.getDirectory(), refdb.getTxnNamespace() + "accepted");
                Files.copy(commited.toPath(), accepted.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    static interface BiFunction {
        public boolean apply(ObjectReader var1, RefTree var2) throws IOException;
    }
}

