/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.impl.git.event;

import java.util.stream.Stream;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public enum NotificationType {
    SUCCESS(0, 0),
    WARNING(1, 30),
    ERROR(31, Integer.MAX_VALUE);

    private int minValue;
    private int maxValue;

    private NotificationType(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    boolean inRange(int exitCode) {
        return this.minValue <= exitCode && exitCode <= this.maxValue;
    }

    public static NotificationType fromExitCode(int exitCode) {
        return Stream.of(NotificationType.values()).filter(type -> type.inRange(exitCode)).findAny().orElse(ERROR);
    }
}

