/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Header;
import org.jgroups.util.Bits;

public class PingHeader
extends Header {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    protected byte type = 0;
    protected String cluster_name;

    public PingHeader() {
    }

    public PingHeader(byte type) {
        this.type = type;
    }

    public byte type() {
        return this.type;
    }

    public PingHeader clusterName(String name) {
        this.cluster_name = name;
        return this;
    }

    @Override
    public int size() {
        int retval = 2;
        if (this.cluster_name != null) {
            retval += this.cluster_name.length() + 2;
        }
        return retval;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type=" + PingHeader.type2Str(this.type));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        sb.append(']');
        return sb.toString();
    }

    static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    @Override
    public void writeTo(DataOutput outstream) throws Exception {
        outstream.writeByte(this.type);
        Bits.writeString(this.cluster_name, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws Exception {
        this.type = instream.readByte();
        this.cluster_name = Bits.readString(instream);
    }
}

