/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing.drools;

import java.util.List;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.PackageDescr;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.ErrorMessageUtilities;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.PackageDescrIndexVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractDrlFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDrlFileIndexer.class);

    public DefaultIndexBuilder fillDrlIndexBuilder(Path path, String drl) throws Exception {
        DrlParser drlParser = new DrlParser();
        PackageDescr packageDescr = drlParser.parse(true, drl);
        if (drlParser.hasErrors()) {
            List errors = drlParser.getErrors();
            logger.warn(ErrorMessageUtilities.makeErrorMessage(path, errors.toArray(new DroolsError[errors.size()])));
            return null;
        }
        if (packageDescr == null) {
            logger.warn(ErrorMessageUtilities.makeErrorMessage(path, new DroolsError[0]));
            return null;
        }
        ModuleDataModelOracle dmo = this.getModuleDataModelOracle(path);
        DefaultIndexBuilder builder = this.getIndexBuilder(path);
        if (builder == null) {
            return null;
        }
        builder.setPackageName(packageDescr.getName());
        PackageDescrIndexVisitor visitor = new PackageDescrIndexVisitor(dmo, builder, packageDescr);
        visitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, visitor);
        return builder;
    }

    protected String getPackageName(Path path) {
        return this.moduleService.resolvePackage(Paths.convert((Path)path)).getPackageName();
    }

    protected abstract ModuleDataModelOracle getModuleDataModelOracle(Path var1);
}

