/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterParameters {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterParameters.class);
    public static final String APPFORMER_CLUSTER = "appformer-cluster";
    public static final String APPFORMER_DEFAULT_CLUSTER_CONFIGS = "appformer-default-cluster-configs";
    public static final String APPFORMER_JMS_URL = "appformer-jms-url";
    public static final String APPFORMER_JMS_USERNAME = "appformer-jms-username";
    public static final String APPFORMER_JMS_PASSWORD = "appformer-jms-password";
    private Boolean appFormerClustered = Boolean.valueOf(System.getProperty("appformer-cluster", "false"));
    private String jmsURL;
    private String jmsUserName;
    private String jmsPassword;

    public ClusterParameters() {
        if (this.appFormerClustered.booleanValue()) {
            Boolean defaultConfigs = Boolean.valueOf(System.getProperty(APPFORMER_DEFAULT_CLUSTER_CONFIGS, "false"));
            if (defaultConfigs.booleanValue()) {
                this.setupDefaultConfigs();
            } else {
                this.loadConfigs();
            }
        }
    }

    private void setupDefaultConfigs() {
        this.jmsURL = "tcp://localhost:61616";
        this.jmsUserName = "admin";
        this.jmsPassword = "admin";
    }

    private void loadConfigs() {
        this.jmsURL = System.getProperty(APPFORMER_JMS_URL);
        this.jmsUserName = System.getProperty(APPFORMER_JMS_USERNAME);
        this.jmsPassword = System.getProperty(APPFORMER_JMS_PASSWORD);
        if (this.jmsURL == null || this.jmsPassword == null || this.jmsPassword == null) {
            throw new RuntimeException(this.buildErrorMessage().toString());
        }
    }

    private StringBuilder buildErrorMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("There is a error on appFormer cluster configurations: ");
        sb.append("appformer-cluster: " + this.appFormerClustered);
        sb.append("appformer-jms-url: " + this.jmsURL);
        sb.append("appformer-jms-username: " + this.jmsPassword);
        sb.append("appformer-jms-password: " + this.jmsPassword);
        return sb;
    }

    public Boolean isAppFormerClustered() {
        return this.appFormerClustered;
    }

    public String getJmsURL() {
        return this.jmsURL;
    }

    public String getJmsUserName() {
        return this.jmsUserName;
    }

    public String getJmsPassword() {
        return this.jmsPassword;
    }
}

