/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project;

import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.ExternalMigrationService;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.kie.workbench.common.project.cli.MigrationSetup;
import org.kie.workbench.common.project.cli.PromptService;

public class ProjectMigrationTool
implements MigrationTool {
    public static final String NAME = "Project structure migration";
    private SystemAccess system;
    private ToolConfig config;
    private Path niogitDir;

    public String getTitle() {
        return NAME;
    }

    public String getDescription() {
        return "Moves old project structure to new modules structure";
    }

    public Integer getPriority() {
        return 0;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        this.niogitDir = config.getTarget();
        PromptService promptService = new PromptService(system, config);
        system.out().println("Starting project structure migration");
        if (this.validateTarget() && promptService.maybePromptForBackup()) {
            ExternalMigrationService externalService = new ExternalMigrationService(system);
            externalService.moveSystemRepos(this.niogitDir);
            MigrationSetup.configureProperties(system, this.niogitDir);
            this.migrate();
        }
    }

    private boolean validateTarget() {
        if (this.config.getTarget().resolve("system").resolve("system.git").toFile().exists()) {
            this.system.err().println(String.format("The target path looks like it already contains an updated filesystem: %s", this.niogitDir));
            return false;
        }
        return true;
    }

    private void migrate() {
        WeldContainer container = null;
        try {
            container = new Weld().initialize();
            InternalMigrationService internalService = ProjectMigrationTool.loadInternalService(container);
            internalService.migrateAllProjects(this.niogitDir);
        }
        catch (Throwable t) {
            this.system.err().println("Error during migration: ");
            t.printStackTrace(this.system.err());
        }
        finally {
            if (container != null && container.isRunning()) {
                this.quietShutdown(container);
            }
        }
    }

    private void quietShutdown(WeldContainer container) {
        try {
            container.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static InternalMigrationService loadInternalService(WeldContainer container) {
        return (InternalMigrationService)container.instance().select(InternalMigrationService.class, new Annotation[0]).get();
    }
}

