/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.analysis.Analyzer;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.project.cli.CommandLineAuthService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.ImpactAnalysisAnalyzerWrapperFactory;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.LowerCaseOnlyAnalyzer;
import org.uberfire.backend.server.IOWatchServiceAllImpl;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.backend.lucene.index.CustomAnalyzerWrapperFactory;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.server.cdi.UberFireGeneralFactory;

@ApplicationScoped
@Specializes
public class CommandLineSetup
extends UberFireGeneralFactory {
    @Produces
    @Singleton
    public User user() {
        return CommandLineAuthService.PLACEHOLDER;
    }

    @Produces
    @Singleton
    public MVELEvaluator mvelEvaluator() {
        return new RawMVELEvaluator();
    }

    @Produces
    @Singleton
    @Named(value="luceneConfig")
    public MetadataConfig luceneConfig() {
        return new MetadataConfigBuilder().withInMemoryMetaModelStore().usingAnalyzers(this.getAnalyzers()).usingAnalyzerWrapperFactory((CustomAnalyzerWrapperFactory)ImpactAnalysisAnalyzerWrapperFactory.getInstance()).useDirectoryBasedIndex().useNIODirectory().build();
    }

    @Produces
    @Named(value="ioStrategy")
    @Singleton
    public IOService ioService(IOWatchServiceAllImpl watchService) {
        return new IOServiceNio2WrapperImpl("1", (IOWatchService)watchService);
    }

    @Produces
    @Default
    @ApplicationScoped
    public SessionInfo getSessionInfo(AuthenticationService authenticationService) {
        return new SessionInfoImpl("dummy-id", authenticationService.getUser());
    }

    Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("libraryFileName", new FilenameAnalyzer());
                this.put("libraryProjectRoot", new FilenameAnalyzer());
                this.put("projectRoot", new FilenameAnalyzer());
                this.put("packageName", new LowerCaseOnlyAnalyzer());
                this.put("filename", new FilenameAnalyzer());
            }
        };
    }
}

