/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.legacy.services.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.parsers.DOMParser;
import org.kie.workbench.common.forms.migration.legacy.model.DataHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.legacy.services.FieldTypeManager;
import org.kie.workbench.common.forms.migration.legacy.services.FormSerializationManager;
import org.kie.workbench.common.forms.migration.legacy.services.impl.util.XMLNode;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FormSerializationManagerImpl
implements FormSerializationManager {
    public static final String NODE_FORM = "form";
    public static final String NODE_FIELD = "field";
    public static final String NODE_PROPERTY = "property";
    public static final String NODE_DATA_HOLDER = "dataHolder";
    public static final String ATTR_ID = "id";
    public static final String ATTR_INPUT_ID = "inputId";
    public static final String ATTR_OUT_ID = "outId";
    public static final String ATTR_POSITION = "position";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_BAG_TYPE = "bag-type";
    public static final String ATTR_SUPPORTED_TYPE = "supportedType";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    protected FieldTypeManager fieldTypeManager = FieldTypeManager.get();

    @Override
    public String generateFormXML(Form form, SystemAccess system) {
        XMLNode rootNode = new XMLNode(NODE_FORM, null);
        try {
            return this.generateFormXML(form, rootNode);
        }
        catch (Exception e) {
            system.err().println("Error serializing form to XML:");
            e.printStackTrace(system.err());
            return "";
        }
    }

    @Override
    public Form loadFormFromXML(String xml) throws Exception {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return null;
        }
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(new StringReader(xml)));
        Document doc = parser.getDocument();
        NodeList nodes = doc.getElementsByTagName(NODE_FORM);
        Node rootNode = nodes.item(0);
        return this.deserializeForm(rootNode);
    }

    public Form deserializeForm(Node nodeForm) throws Exception {
        if (!nodeForm.getNodeName().equals(NODE_FORM)) {
            return null;
        }
        Form form = new Form();
        form.setId(Long.valueOf(StringEscapeUtils.unescapeXml((String)nodeForm.getAttributes().getNamedItem(ATTR_ID).getNodeValue())));
        TreeSet<Field> fields = new TreeSet<Field>();
        NodeList childNodes = nodeForm.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals(NODE_PROPERTY)) {
                String propName = node.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                String value = StringEscapeUtils.unescapeXml((String)node.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
                if ("subject".equals(propName)) {
                    form.setSubject(value);
                    continue;
                }
                if (ATTR_NAME.equals(propName)) {
                    form.setName(value);
                    continue;
                }
                if ("displayMode".equals(propName)) {
                    form.setDisplayMode(value);
                    continue;
                }
                if ("labelMode".equals(propName)) {
                    form.setLabelMode(value);
                    continue;
                }
                if ("showMode".equals(propName)) {
                    form.setShowMode(value);
                    continue;
                }
                if ("status".equals(propName)) {
                    form.setStatus(Long.valueOf(value));
                    continue;
                }
                if ("formTemplate".equals(propName)) {
                    form.setFormTemplate(value);
                    continue;
                }
                if (!"migrationStep".equals(propName)) continue;
                form.setMigrationStep(Integer.decode(value));
                continue;
            }
            if (node.getNodeName().equals(NODE_FIELD)) {
                Field field = this.deserializeField(node);
                field.setForm(form);
                fields.add(field);
                continue;
            }
            if (!node.getNodeName().equals(NODE_DATA_HOLDER)) continue;
            String holderId = this.getNodeAttributeValue(node, ATTR_ID);
            String holderInputId = this.getNodeAttributeValue(node, ATTR_INPUT_ID);
            String holderOutId = this.getNodeAttributeValue(node, ATTR_OUT_ID);
            String holderType = this.getNodeAttributeValue(node, ATTR_TYPE);
            String holderValue = this.getNodeAttributeValue(node, ATTR_VALUE);
            String holderRenderColor = this.getNodeAttributeValue(node, ATTR_NAME);
            String holderSupportedType = this.getNodeAttributeValue(node, ATTR_SUPPORTED_TYPE);
            DataHolder dataHolder = new DataHolder(holderId, holderInputId, holderOutId, holderType, holderValue, holderRenderColor, holderSupportedType);
            form.setDataHolder(dataHolder);
        }
        if (fields != null) {
            form.setFormFields(fields);
        }
        return form;
    }

    protected String getNodeAttributeValue(Node node, String attributeName) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        return attribute != null ? attribute.getNodeValue() : "";
    }

    private void addXMLNode(String propName, String value, XMLNode parent) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            XMLNode propertyNode = new XMLNode(NODE_PROPERTY, parent);
            propertyNode.addAttribute(ATTR_NAME, propName);
            propertyNode.addAttribute(ATTR_VALUE, value);
            parent.addChild(propertyNode);
        }
    }

    public String generateFormXML(Form form, XMLNode rootNode) throws Exception {
        rootNode.addAttribute(ATTR_ID, form.getId().toString());
        this.addXMLNode("subject", form.getSubject(), rootNode);
        this.addXMLNode(ATTR_NAME, form.getName(), rootNode);
        this.addXMLNode("displayMode", form.getDisplayMode(), rootNode);
        this.addXMLNode("labelMode", form.getLabelMode(), rootNode);
        this.addXMLNode("showMode", form.getShowMode(), rootNode);
        this.addXMLNode("status", form.getStatus() != null ? String.valueOf(form.getStatus()) : null, rootNode);
        this.addXMLNode("formTemplate", form.getFormTemplate(), rootNode);
        this.addXMLNode("migrationStep", String.valueOf(form.getMigrationStep()), rootNode);
        for (Field field : form.getFormFields()) {
            this.generateFieldXML(field, rootNode);
        }
        for (DataHolder dataHolder : form.getHolders()) {
            this.generateDataHolderXML(dataHolder, rootNode);
        }
        StringWriter sw = new StringWriter();
        rootNode.writeXML(sw, true);
        return sw.toString();
    }

    public Field deserializeField(Node nodeField) throws Exception {
        if (!nodeField.getNodeName().equals(NODE_FIELD)) {
            return null;
        }
        Field field = new Field();
        field.setId(Long.valueOf(nodeField.getAttributes().getNamedItem(ATTR_ID).getNodeValue()));
        field.setFieldName(nodeField.getAttributes().getNamedItem(ATTR_NAME).getNodeValue());
        field.setPosition(Integer.parseInt(nodeField.getAttributes().getNamedItem(ATTR_POSITION).getNodeValue()));
        field.setFieldType(this.fieldTypeManager.getTypeByCode(nodeField.getAttributes().getNamedItem(ATTR_TYPE).getNodeValue()));
        Node bag = nodeField.getAttributes().getNamedItem(ATTR_BAG_TYPE);
        if (bag != null) {
            field.setBag(bag.getNodeValue());
        }
        NodeList fieldPropsNodes = nodeField.getChildNodes();
        for (int j = 0; j < fieldPropsNodes.getLength(); ++j) {
            Node nodeFieldProp = fieldPropsNodes.item(j);
            if (!nodeFieldProp.getNodeName().equals(NODE_PROPERTY)) continue;
            String propName = nodeFieldProp.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
            String value = StringEscapeUtils.unescapeXml((String)nodeFieldProp.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
            if (propName == null || value == null) continue;
            if ("fieldRequired".equals(propName)) {
                field.setFieldRequired(Boolean.valueOf(value));
                continue;
            }
            if ("groupWithPrevious".equals(propName)) {
                field.setGroupWithPrevious(Boolean.valueOf(value));
                continue;
            }
            if ("height".equals(propName)) {
                field.setHeight(value);
                continue;
            }
            if ("labelCSSClass".equals(propName)) {
                field.setLabelCSSClass(value);
                continue;
            }
            if ("labelCSSStyle".equals(propName)) {
                field.setLabelCSSStyle(value);
                continue;
            }
            if ("label".equals(propName)) {
                field.setLabel(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("errorMessage".equals(propName)) {
                field.setErrorMessage(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("title".equals(propName)) {
                field.setTitle(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("readonly".equals(propName)) {
                field.setReadonly(Boolean.valueOf(value));
                continue;
            }
            if ("size".equals(propName)) {
                if (StringUtils.isEmpty((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value)) continue;
                field.setSize(Long.valueOf(value));
                continue;
            }
            if ("formula".equals(propName)) {
                field.setFormula(value);
                continue;
            }
            if ("rangeFormula".equals(propName)) {
                field.setRangeFormula(value);
                continue;
            }
            if ("pattern".equals(propName)) {
                field.setPattern(value);
                continue;
            }
            if ("maxlength".equals(propName)) {
                if (StringUtils.isEmpty((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value)) continue;
                field.setMaxlength(Long.valueOf(value));
                continue;
            }
            if ("styleclass".equals(propName)) {
                field.setStyleclass(value);
                continue;
            }
            if ("cssStyle".equals(propName)) {
                field.setCssStyle(value);
                continue;
            }
            if ("tabindex".equals(propName)) {
                if (StringUtils.isEmpty((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value)) continue;
                field.setTabindex(Long.valueOf(value));
                continue;
            }
            if ("accesskey".equals(propName)) {
                field.setAccesskey(value);
                continue;
            }
            if ("isHTML".equals(propName)) {
                field.setIsHTML(Boolean.valueOf(value));
                continue;
            }
            if ("htmlContent".equals(propName)) {
                field.setHtmlContent(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("hideContent".equals(propName)) {
                field.setHideContent(Boolean.valueOf(value));
                continue;
            }
            if ("defaultValueFormula".equals(propName)) {
                field.setDefaultValueFormula(value);
                continue;
            }
            if ("defaultSubform".equals(propName)) {
                field.setDefaultSubform(value);
                continue;
            }
            if ("previewSubform".equals(propName)) {
                field.setPreviewSubform(value);
                continue;
            }
            if ("tableSubform".equals(propName)) {
                field.setTableSubform(value);
                continue;
            }
            if ("newItemText".equals(propName)) {
                field.setNewItemText(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("addItemText".equals(propName)) {
                field.setAddItemText(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("cancelItemText".equals(propName)) {
                field.setCancelItemText(this.deserializeI18nEntrySet(value));
                continue;
            }
            if ("deleteItems".equals(propName)) {
                field.setDeleteItems(Boolean.valueOf(value));
                continue;
            }
            if ("updateItems".equals(propName)) {
                field.setUpdateItems(Boolean.valueOf(value));
                continue;
            }
            if ("visualizeItems".equals(propName)) {
                field.setVisualizeItem(Boolean.valueOf(value));
                continue;
            }
            if ("hideCreateItem".equals(propName)) {
                field.setHideCreateItem(Boolean.valueOf(value));
                continue;
            }
            if ("expanded".equals(propName)) {
                field.setExpanded(Boolean.valueOf(value));
                continue;
            }
            if ("enableTableEnterData".equals(propName)) {
                field.setEnableTableEnterData(Boolean.valueOf(value));
                continue;
            }
            if ("inputBinding".equals(propName)) {
                field.setInputBinding(value);
                continue;
            }
            if ("outputBinding".equals(propName)) {
                field.setOutputBinding(value);
                continue;
            }
            if ("customFieldType".equals(propName)) {
                field.setCustomFieldType(value);
                continue;
            }
            if ("param1".equals(propName)) {
                field.setParam1(value);
                continue;
            }
            if ("param2".equals(propName)) {
                field.setParam2(value);
                continue;
            }
            if ("param3".equals(propName)) {
                field.setParam3(value);
                continue;
            }
            if ("param4".equals(propName)) {
                field.setParam4(value);
                continue;
            }
            if ("param5".equals(propName)) {
                field.setParam5(value);
                continue;
            }
            if ("fieldClass".equals(propName)) {
                field.getFieldType().setFieldClass(value);
                continue;
            }
            if ("onChangeScript".equals(propName)) {
                field.setOnChangeScript(value);
                continue;
            }
            if (!"movedToForm".equals(propName) || value == null) continue;
            field.setMovedToForm(value);
        }
        return field;
    }

    private String getFieldProperty(String formName, String fieldName, String selector, Properties props) {
        if (props == null) {
            return null;
        }
        String value = props.getProperty(formName + "." + fieldName + "." + selector);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = props.getProperty(fieldName + "." + selector);
        }
        return value;
    }

    public void generateFieldXML(Field field, XMLNode parent) {
        XMLNode rootNode = new XMLNode(NODE_FIELD, parent);
        rootNode.addAttribute(ATTR_ID, String.valueOf(field.getId()));
        rootNode.addAttribute(ATTR_POSITION, String.valueOf(field.getPosition()));
        rootNode.addAttribute(ATTR_NAME, field.getFieldName());
        if (field.getFieldType() != null) {
            rootNode.addAttribute(ATTR_TYPE, field.getFieldType().getCode());
        }
        if (!StringUtils.isEmpty((CharSequence)field.getBag())) {
            rootNode.addAttribute(ATTR_BAG_TYPE, field.getBag());
        }
        this.addXMLNode("fieldRequired", field.getFieldRequired() != null ? String.valueOf(field.getFieldRequired()) : null, rootNode);
        this.addXMLNode("groupWithPrevious", field.getGroupWithPrevious() != null ? String.valueOf(field.getGroupWithPrevious()) : null, rootNode);
        this.addXMLNode("height", field.getHeight(), rootNode);
        this.addXMLNode("labelCSSClass", field.getLabelCSSClass(), rootNode);
        this.addXMLNode("labelCSSStyle", field.getLabelCSSStyle(), rootNode);
        this.addXMLNode("label", field.getLabel() != null ? this.serializeI18nSet(field.getLabel()) : null, rootNode);
        this.addXMLNode("errorMessage", field.getErrorMessage() != null ? this.serializeI18nSet(field.getErrorMessage()) : null, rootNode);
        this.addXMLNode("title", field.getTitle() != null ? this.serializeI18nSet(field.getTitle()) : null, rootNode);
        this.addXMLNode("readonly", field.getReadonly() != null ? String.valueOf(field.getReadonly()) : null, rootNode);
        this.addXMLNode("size", field.getSize() != null ? String.valueOf(field.getSize()) : null, rootNode);
        this.addXMLNode("formula", field.getFormula(), rootNode);
        this.addXMLNode("rangeFormula", field.getRangeFormula(), rootNode);
        this.addXMLNode("pattern", field.getPattern(), rootNode);
        this.addXMLNode("maxlength", field.getMaxlength() != null ? String.valueOf(field.getMaxlength()) : null, rootNode);
        this.addXMLNode("styleclass", field.getStyleclass(), rootNode);
        this.addXMLNode("cssStyle", field.getCssStyle(), rootNode);
        this.addXMLNode("tabindex", field.getTabindex() != null ? String.valueOf(field.getTabindex()) : null, rootNode);
        this.addXMLNode("accesskey", field.getAccesskey(), rootNode);
        this.addXMLNode("isHTML", field.getIsHTML() != null ? String.valueOf(field.getIsHTML()) : null, rootNode);
        this.addXMLNode("hideContent", field.getHideContent() != null ? String.valueOf(field.getHideContent()) : null, rootNode);
        this.addXMLNode("defaultValueFormula", field.getDefaultValueFormula(), rootNode);
        this.addXMLNode("inputBinding", field.getInputBinding(), rootNode);
        this.addXMLNode("outputBinding", field.getOutputBinding(), rootNode);
        this.addXMLNode("htmlContent", field.getHtmlContent() != null ? this.serializeI18nSet(field.getHtmlContent()) : null, rootNode);
        this.addXMLNode("defaultSubform", field.getDefaultSubform(), rootNode);
        this.addXMLNode("previewSubform", field.getPreviewSubform(), rootNode);
        this.addXMLNode("tableSubform", field.getTableSubform(), rootNode);
        this.addXMLNode("newItemText", field.getNewItemText() != null ? this.serializeI18nSet(field.getNewItemText()) : null, rootNode);
        this.addXMLNode("addItemText", field.getAddItemText() != null ? this.serializeI18nSet(field.getAddItemText()) : null, rootNode);
        this.addXMLNode("cancelItemText", field.getCancelItemText() != null ? this.serializeI18nSet(field.getCancelItemText()) : null, rootNode);
        this.addXMLNode("deleteItems", field.getDeleteItems() != null ? String.valueOf(field.getDeleteItems()) : null, rootNode);
        this.addXMLNode("updateItems", field.getUpdateItems() != null ? String.valueOf(field.getUpdateItems()) : null, rootNode);
        this.addXMLNode("visualizeItems", field.getVisualizeItem() != null ? String.valueOf(field.getVisualizeItem()) : null, rootNode);
        this.addXMLNode("hideCreateItem", field.getHideCreateItem() != null ? String.valueOf(field.getHideCreateItem()) : null, rootNode);
        this.addXMLNode("expanded", field.getExpanded() != null ? String.valueOf(field.getExpanded()) : null, rootNode);
        this.addXMLNode("enableTableEnterData", field.getEnableTableEnterData() != null ? String.valueOf(field.getEnableTableEnterData()) : null, rootNode);
        this.addXMLNode("customFieldType", field.getCustomFieldType(), rootNode);
        this.addXMLNode("fieldClass", field.getFieldType().getFieldClass(), rootNode);
        this.addXMLNode("param1", field.getParam1(), rootNode);
        this.addXMLNode("param2", field.getParam2(), rootNode);
        this.addXMLNode("param3", field.getParam3(), rootNode);
        this.addXMLNode("param4", field.getParam4(), rootNode);
        this.addXMLNode("param5", field.getParam5(), rootNode);
        this.addXMLNode("onChangeScript", field.getOnChangeScript(), rootNode);
        if (field.getMovedToForm() != null) {
            this.addXMLNode("movedToForm", field.getMovedToForm(), rootNode);
        }
        parent.addChild(rootNode);
    }

    public void generateDataHolderXML(DataHolder dataHolder, XMLNode parent) {
        XMLNode rootNode = new XMLNode(NODE_DATA_HOLDER, parent);
        rootNode.addAttribute(ATTR_ID, dataHolder.getUniqeId());
        rootNode.addAttribute(ATTR_INPUT_ID, dataHolder.getInputId());
        rootNode.addAttribute(ATTR_OUT_ID, dataHolder.getOuputId());
        rootNode.addAttribute(ATTR_TYPE, dataHolder.getType());
        rootNode.addAttribute(ATTR_VALUE, dataHolder.getClassName());
        rootNode.addAttribute(ATTR_NAME, dataHolder.getRenderColor());
        if (!StringUtils.isEmpty((CharSequence)dataHolder.getSupportedType())) {
            rootNode.addAttribute(ATTR_SUPPORTED_TYPE, dataHolder.getSupportedType());
        }
        parent.addChild(rootNode);
    }

    protected String[] decodeStringArray(String textValue) {
        if (textValue == null || textValue.trim().length() == 0) {
            return new String[0];
        }
        String[] lista = textValue.split("quot;");
        return lista;
    }

    protected String encodeStringArray(String[] value) {
        String cad = "";
        for (int i = 0; i < value.length; ++i) {
            cad = cad + "quot;" + value[i] + "quot;";
            cad = cad + ",quot;" + value[++i] + "quot;";
        }
        return cad;
    }

    public String serializeI18nSet(Map<String, String> i18nSet) {
        String[] values = new String[i18nSet.entrySet().size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : i18nSet.entrySet()) {
            values[i] = entry.getKey();
            values[++i] = entry.getValue();
            ++i;
        }
        return this.encodeStringArray(values);
    }

    public Map<String, String> deserializeI18nEntrySet(String cadena) {
        String[] values = this.decodeStringArray(cadena);
        HashMap<String, String> mapValues = new HashMap<String, String>();
        for (int i = 0; i < values.length; i += 4) {
            String key = values[i + 1];
            String value = "";
            if (i + 3 < values.length) {
                value = values[i + 3];
            }
            if (key.length() != 2) continue;
            mapValues.put(key, value);
        }
        return mapValues;
    }
}

