/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.legacy.services.FormSerializationManager;
import org.kie.workbench.common.forms.migration.legacy.services.impl.FormSerializationManagerImpl;
import org.kie.workbench.common.forms.migration.tool.FormMigrationSummary;
import org.kie.workbench.common.forms.migration.tool.Resource;
import org.kie.workbench.common.forms.migration.tool.cdi.MigrationServicesCDIWrapper;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationContext;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationPipeline;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.MigrationSetup;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;

public class FormsMigrationTool
implements MigrationTool {
    private FormSerializationManager legacyFormSerializer = new FormSerializationManagerImpl();
    private SystemAccess system;
    private ToolConfig config;
    private java.nio.file.Path niogitDir;
    private WeldContainer weldContainer;
    private MigrationServicesCDIWrapper cdiWrapper;
    private MigrationPipeline pipeline;

    public String getTitle() {
        return "Forms migration";
    }

    public String getDescription() {
        return "Moves old jBPM Form Modeler forms into the new Forms format.";
    }

    public Integer getPriority() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        this.niogitDir = config.getTarget();
        system.out().println("\nStarting Forms migration");
        if (this.projectMigrationWasExecuted()) {
            try {
                MigrationSetup.configureProperties((SystemAccess)system, (java.nio.file.Path)this.niogitDir);
                this.weldContainer = new Weld().initialize();
                this.cdiWrapper = (MigrationServicesCDIWrapper)this.weldContainer.instance().select(MigrationServicesCDIWrapper.class, new Annotation[0]).get();
                if (this.systemMigrationWasExecuted()) {
                    this.pipeline = new MigrationPipeline();
                    if (!config.isBatch()) {
                        String response;
                        system.out().println(this.pipeline.getAllInfo());
                        List<String> validResponses = Arrays.asList("yes", "no");
                        while (!validResponses.contains(response = system.console().readLine("\nDo you want to continue? [yes/no]: ", new Object[0]).toLowerCase())) {
                        }
                        if ("no".equals(response)) {
                            return;
                        }
                    }
                    WorkspaceProjectService service = (WorkspaceProjectService)this.weldContainer.instance().select(WorkspaceProjectService.class, new Annotation[0]).get();
                    service.getAllWorkspaceProjects().forEach(this::processWorkspaceProject);
                }
            }
            finally {
                if (this.weldContainer != null) {
                    try {
                        this.cdiWrapper = null;
                        this.weldContainer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void processWorkspaceProject(WorkspaceProject workspaceProject) {
        final ArrayList<FormMigrationSummary> summaries = new ArrayList<FormMigrationSummary>();
        Files.walkFileTree((Path)Paths.convert((org.uberfire.backend.vfs.Path)workspaceProject.getRootPath()), (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attrs) throws IOException {
                org.uberfire.backend.vfs.Path visitedVFSPath = Paths.convert((Path)visitedPath);
                String fileName = visitedVFSPath.getFileName();
                File file = visitedPath.toFile();
                if (file.isFile() && fileName.endsWith(".form")) {
                    try {
                        Form legacyForm = FormsMigrationTool.this.legacyFormSerializer.loadFormFromXML(FormsMigrationTool.this.cdiWrapper.getIOService().readAllString(visitedPath));
                        FormMigrationSummary summary = new FormMigrationSummary(new Resource<Form>(legacyForm, visitedVFSPath));
                        String newFormFileName = fileName.substring(0, fileName.lastIndexOf(".") - 1) + "frm";
                        Path newFormPath = visitedPath.getParent().resolve(newFormFileName);
                        if (FormsMigrationTool.this.cdiWrapper.getIOService().exists(newFormPath)) {
                            Resource<FormDefinition> newFormResource = new Resource<FormDefinition>(FormsMigrationTool.this.cdiWrapper.getFormDefinitionSerializer().deserialize(FormsMigrationTool.this.cdiWrapper.getIOService().readAllString(newFormPath)), Paths.convert((Path)newFormPath));
                            summary.setNewFormResource(newFormResource);
                        }
                        summaries.add(summary);
                    }
                    catch (Exception e) {
                        FormsMigrationTool.this.system.err().println("Error reading form: " + fileName + ":\n");
                        e.printStackTrace(FormsMigrationTool.this.system.err());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        this.system.console().format("\nProcessing module %s: %s forms found\n", new Object[]{workspaceProject.getName(), summaries.size()});
        MigrationContext context = new MigrationContext(workspaceProject, this.weldContainer, this.cdiWrapper, this.system, summaries);
        this.pipeline.migrate(context);
    }

    private boolean projectMigrationWasExecuted() {
        if (!this.config.getTarget().resolve("system").resolve("system.git").toFile().exists()) {
            this.system.err().println(String.format("The PROJECT STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean systemMigrationWasExecuted() {
        Repository systemRepository;
        IOService systemIoService = this.cdiWrapper.getSystemIoService();
        if (!systemIoService.exists(systemIoService.get((systemRepository = this.cdiWrapper.getSystemRepository()).getUri(), new String[0]).resolve("spaces"))) {
            this.system.err().println(String.format("The SYSTEM CONFIGURATION DIRECTORY STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
            return false;
        }
        return true;
    }

    private void configureProperties() {
        this.system.setProperty("org.uberfire.nio.git.dir", this.niogitDir.getParent().toString());
        this.system.setProperty("org.uberfire.nio.git.dirname", this.niogitDir.getFileName().toString());
        this.system.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        this.system.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
    }
}

