/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Snippet;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;

public class CustomPassageFormatter
extends PassageFormatter {
    private final String preTag;
    private final String postTag;
    private final Encoder encoder;

    public CustomPassageFormatter(String preTag, String postTag, Encoder encoder) {
        this.preTag = preTag;
        this.postTag = postTag;
        this.encoder = encoder;
    }

    public Snippet[] format(Passage[] passages, String content) {
        Snippet[] snippets = new Snippet[passages.length];
        for (int j = 0; j < passages.length; ++j) {
            Passage passage = passages[j];
            StringBuilder sb = new StringBuilder();
            int pos = passage.getStartOffset();
            for (int i = 0; i < passage.getNumMatches(); ++i) {
                int start = passage.getMatchStarts()[i];
                int end = passage.getMatchEnds()[i];
                if (start > pos) {
                    this.append(sb, content, pos, start);
                }
                if (end <= pos) continue;
                sb.append(this.preTag);
                this.append(sb, content, Math.max(pos, start), end);
                sb.append(this.postTag);
                pos = end;
            }
            this.append(sb, content, pos, Math.max(pos, passage.getEndOffset()));
            if (sb.charAt(sb.length() - 1) == '\u2029') {
                sb.deleteCharAt(sb.length() - 1);
            } else if (sb.charAt(sb.length() - 1) == '\u0000') {
                sb.deleteCharAt(sb.length() - 1);
            }
            snippets[j] = new Snippet(sb.toString().trim(), passage.getScore(), passage.getNumMatches() > 0);
        }
        return snippets;
    }

    private void append(StringBuilder dest, String content, int start, int end) {
        dest.append(this.encoder.encodeText(content.substring(start, end)));
    }
}

