/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaObject;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaProperty;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.impl.KObjectImpl;
import org.uberfire.ext.metadata.model.impl.KPropertyImpl;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.attribute.FileTime;

public class MappingFieldFactory {
    public static final String CHECKIN_COMMENT = "checkinComment";
    public static final String LAST_MODIFIED_BY = "lastModifiedBy";
    public static final String CREATED_BY = "createdBy";
    public static final String CREATED_DATE = "createdDate";
    public static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    private final MetaModelStore metaModelStore;

    public MappingFieldFactory(MetaModelStore metaModelStore) {
        this.metaModelStore = metaModelStore;
    }

    public MetaObject build(KObject kObject) {
        ElasticMetaObject metaObject = new ElasticMetaObject(kObject.getType());
        metaObject.addProperty(new ElasticMetaProperty("id", kObject.getId(), new HashSet(Arrays.asList(String.class))));
        metaObject.addProperty(new ElasticMetaProperty("type", kObject.getType().getName(), new HashSet(Arrays.asList(String.class))));
        metaObject.addProperty(new ElasticMetaProperty("key", kObject.getKey(), new HashSet(Arrays.asList(String.class))));
        metaObject.addProperty(new ElasticMetaProperty("cluster.id", kObject.getClusterId(), new HashSet(Arrays.asList(String.class))));
        metaObject.addProperty(new ElasticMetaProperty("segment.id", kObject.getSegmentId(), new HashSet(Arrays.asList(String.class))));
        StringBuilder allText = new StringBuilder(kObject.getKey()).append('\n');
        if (kObject.getProperties() != null) {
            kObject.getProperties().forEach(kProperty -> {
                List<ElasticMetaProperty> properties = this.build((KProperty<?>)kProperty);
                properties.forEach(elasticMetaProperty -> {
                    metaObject.addProperty((MetaProperty)elasticMetaProperty);
                    if (elasticMetaProperty.isSearchable() && !elasticMetaProperty.isBoolean()) {
                        allText.append(elasticMetaProperty.getValue()).append('\n');
                    }
                });
            });
        }
        if (kObject.fullText()) {
            metaObject.addProperty(new ElasticMetaProperty("fullText", allText.toString().toLowerCase(), new HashSet(Arrays.asList(String.class)), false, true));
        }
        return metaObject;
    }

    private List<ElasticMetaProperty> build(KProperty<?> property) {
        if (Enum.class.isAssignableFrom(property.getValue().getClass())) {
            return Arrays.asList(new ElasticMetaProperty(property.getName(), property.getValue().toString().toLowerCase(), new HashSet(Arrays.asList(String.class)), property.isSortable(), property.isSearchable()));
        }
        if (FileTime.class.isAssignableFrom(property.getValue().getClass())) {
            return Arrays.asList(new ElasticMetaProperty(property.getName(), String.valueOf(((FileTime)property.getValue()).toMillis()), new HashSet(Arrays.asList(Long.class)), property.isSortable(), property.isSearchable()));
        }
        if (Date.class.isAssignableFrom(property.getValue().getClass())) {
            return Arrays.asList(new ElasticMetaProperty(property.getName(), String.valueOf(((Date)property.getValue()).getTime()), new HashSet(Arrays.asList(Long.class)), property.isSortable(), property.isSearchable()));
        }
        if (Collection.class.isAssignableFrom(property.getValue().getClass())) {
            Collection values = (Collection)property.getValue();
            String content = values.stream().map(Object::toString).collect(Collectors.joining(" "));
            return Arrays.asList(new ElasticMetaProperty(property.getName(), content, new HashSet(Arrays.asList(String.class)), property.isSortable(), property.isSearchable()));
        }
        if (VersionHistory.class.isAssignableFrom(property.getValue().getClass())) {
            VersionHistory versionHistory = (VersionHistory)property.getValue();
            return this.build(versionHistory);
        }
        return Arrays.asList(new ElasticMetaProperty(property.getName(), property.getValue().toString(), new HashSet(Arrays.asList(property.getValue().getClass())), property.isSortable(), property.isSearchable()));
    }

    private List<ElasticMetaProperty> build(VersionHistory versionHistory) {
        if (versionHistory.records().size() == 0) {
            return Collections.emptyList();
        }
        int lastIndex = versionHistory.records().size() - 1;
        ArrayList<ElasticMetaProperty> properties = new ArrayList<ElasticMetaProperty>();
        properties.addAll(this.build(this.buildKProperty(CHECKIN_COMMENT, ((VersionRecord)versionHistory.records().get(lastIndex)).comment(), true)));
        properties.addAll(this.build(this.buildKProperty(LAST_MODIFIED_BY, ((VersionRecord)versionHistory.records().get(lastIndex)).author(), true)));
        properties.addAll(this.build(this.buildKProperty(CREATED_BY, ((VersionRecord)versionHistory.records().get(0)).author(), true)));
        properties.addAll(this.build(this.buildKProperty(CREATED_DATE, ((VersionRecord)versionHistory.records().get(0)).date(), true)));
        properties.addAll(this.build(this.buildKProperty(LAST_MODIFIED_DATE, ((VersionRecord)versionHistory.records().get(lastIndex)).date(), true)));
        return properties;
    }

    private <T> KProperty<T> buildKProperty(final String name, final T value, final boolean searchable) {
        return new KProperty<T>(){

            public String getName() {
                return name;
            }

            public T getValue() {
                return value;
            }

            public boolean isSearchable() {
                return searchable;
            }
        };
    }

    public KObject fromDocument(Map<String, ?> document) {
        MetaObject metaModel = this.metaModelStore.getMetaObject((String)document.get("type"));
        Collection properties = metaModel.getProperties();
        List<KProperty<?>> kProperties = this.buildKProperties(document, properties);
        return new KObjectImpl(String.valueOf(document.get("id")), String.valueOf(document.get("type")), String.valueOf(document.get("cluster.id")), String.valueOf(document.get("segment.id")), String.valueOf(document.get("key")), kProperties, false);
    }

    private List<KProperty<?>> buildKProperties(Map<String, ?> document, Collection<MetaProperty> properties) {
        return properties.stream().map(metaProperty -> new KPropertyImpl(metaProperty.getName(), document.get(metaProperty.getName()), metaProperty.isSearchable())).collect(Collectors.toList());
    }
}

