/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.appformer.maven.support.MinimalPomParser;
import org.appformer.maven.support.PomModel;
import org.eclipse.aether.artifact.Artifact;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.model.JarListPageRequest;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class M2RepoServiceImpl
implements M2RepoService,
ExtendedM2RepoService {
    private GuvnorM2Repository repository;

    public M2RepoServiceImpl() {
    }

    @Inject
    public M2RepoServiceImpl(GuvnorM2Repository repository) {
        this.repository = repository;
    }

    @Override
    public void deployJar(InputStream is, GAV gav) {
        this.repository.deployArtifact(is, gav, true);
    }

    @Override
    public void deployJarInternal(InputStream is, GAV gav) {
        this.repository.deployArtifact(is, gav, false);
    }

    @Override
    public void deployPom(InputStream is, GAV gav) {
        this.repository.deployPom(is, gav);
    }

    public String getPomText(String path) {
        this.checkPathTraversal(path);
        return this.repository.getPomText(path);
    }

    public GAV loadGAVFromJar(String path) {
        this.checkPathTraversal(path);
        GAV gav = this.repository.loadGAVFromJar(path);
        return gav;
    }

    public PageResponse<JarListPageRow> listArtifacts(JarListPageRequest pageRequest) {
        String filters = pageRequest.getFilters();
        List fileFormats = pageRequest.getFileFormats();
        String dataSourceName = pageRequest.getDataSourceName();
        boolean isAscending = pageRequest.isAscending();
        List<Artifact> files = this.repository.listArtifacts(filters, fileFormats);
        ArrayList<JarListPageRow> jarPageRowList = new ArrayList<JarListPageRow>();
        for (Artifact artifact : files) {
            File file = artifact.getFile();
            JarListPageRow jarListPageRow = new JarListPageRow();
            jarListPageRow.setName(file.getName());
            jarListPageRow.setPath(this.getJarPath(file.getPath(), File.separator));
            jarListPageRow.setGav(this.getGAV(jarListPageRow.getPath()));
            jarListPageRow.setLastModified(new Date(file.lastModified()));
            jarListPageRow.setRepositoryName(artifact.getProperty("repository", "undefined"));
            jarPageRowList.add(jarListPageRow);
        }
        if (dataSourceName != null) {
            int order;
            int n = order = isAscending ? 1 : -1;
            if (dataSourceName.equals("org.guvnor.m2repo.model.name")) {
                Collections.sort(jarPageRowList, new Comparator<JarListPageRow>(){

                    @Override
                    public int compare(JarListPageRow o1, JarListPageRow o2) {
                        return o1.getName().compareTo(o2.getName()) * order;
                    }
                });
            } else if (dataSourceName.equals("org.guvnor.m2repo.model.path")) {
                Collections.sort(jarPageRowList, new Comparator<JarListPageRow>(){

                    @Override
                    public int compare(JarListPageRow o1, JarListPageRow o2) {
                        return o1.getPath().compareTo(o2.getPath()) * order;
                    }
                });
            } else if (dataSourceName.equals("org.guvnor.m2repo.model.gav")) {
                Collections.sort(jarPageRowList, new Comparator<JarListPageRow>(){

                    @Override
                    public int compare(JarListPageRow o1, JarListPageRow o2) {
                        GAV gav1 = o1.getGav();
                        GAV gav2 = o2.getGav();
                        return gav1.toString().compareToIgnoreCase(gav2.toString()) * order;
                    }
                });
            } else if (dataSourceName.equals("org.guvnor.m2repo.model.last.modified")) {
                Collections.sort(jarPageRowList, new Comparator<JarListPageRow>(){

                    @Override
                    public int compare(JarListPageRow o1, JarListPageRow o2) {
                        Long ft1 = o1.getLastModified().getTime();
                        Long ft2 = o2.getLastModified().getTime();
                        return ft1.compareTo(ft2) * order;
                    }
                });
            }
        }
        Integer pageSize = pageRequest.getPageSize();
        int startRowIndex = pageRequest.getStartRowIndex();
        int endRowIndex = Math.min(jarPageRowList.size(), pageSize == null ? jarPageRowList.size() : startRowIndex + pageSize);
        ArrayList responsePageRowList = new ArrayList();
        if (startRowIndex < jarPageRowList.size()) {
            for (int i = startRowIndex; i < endRowIndex && i < jarPageRowList.size(); ++i) {
                responsePageRowList.add(jarPageRowList.get(i));
            }
        }
        PageResponse response = new PageResponse();
        response.setPageRowList(responsePageRowList);
        response.setStartRowIndex(pageRequest.getStartRowIndex());
        response.setTotalRowSize(files.size());
        response.setTotalRowSizeExact(true);
        return response;
    }

    String getJarPath(String path, String separator) {
        String pathToDir = this.repository.getM2RepositoryDir("global-m2-repo");
        String jarPath = path.substring(pathToDir.length() + 1);
        jarPath = jarPath.replaceAll("\\" + separator, "/");
        return jarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GAV getGAV(String path) {
        GAV gav = null;
        InputStream is = null;
        try {
            String pom = this.getPomText(path);
            is = new ByteArrayInputStream(pom.getBytes(Charset.forName("UTF-8")));
            PomModel model = MinimalPomParser.parse((String)path, (InputStream)is);
            gav = new GAV(model.getReleaseId().getGroupId(), model.getReleaseId().getArtifactId(), model.getReleaseId().getVersion());
        }
        catch (RuntimeException rte) {
            gav = new GAV("<undetermined>", "<undetermined>", "<undetermined>");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return gav;
    }

    public String getRepositoryURL(String baseURL) {
        if (baseURL == null || baseURL.isEmpty()) {
            return this.repository.getRepositoryURL("global-m2-repo");
        }
        if (baseURL.endsWith("/")) {
            return baseURL + "maven2/";
        }
        return baseURL + "/maven2/";
    }

    private void checkPathTraversal(String path) {
        if (path.contains("..")) {
            throw new RuntimeException("Invalid path provided!");
        }
    }
}

