/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.persistence;

import java.io.Serializable;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.persistence.SocialUserClusterMessageWrapper;
import org.ext.uberfire.social.activities.persistence.SocialUserClusterPersistence;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class SocialUserClusterMessaging {
    public static final String CHANNEL_NAME = "SOCIAL_USER_MESSAGE";
    private SocialUserPersistenceAPI socialUserPersistenceAPI;
    private ClusterService clusterService;
    private String nodeId = UUID.randomUUID().toString();

    public void setup(ClusterService clusterService, SocialUserPersistenceAPI socialUserPersistenceAPI) {
        this.clusterService = clusterService;
        this.socialUserPersistenceAPI = socialUserPersistenceAPI;
        if (clusterService.isAppFormerClustered()) {
            clusterService.connect();
            clusterService.createConsumer(ClusterService.DestinationType.PubSub, CHANNEL_NAME, SocialUserClusterMessageWrapper.class, message -> {
                if (!message.getNodeId().equals(this.nodeId)) {
                    SocialUserClusterPersistence socialUserClusterPersistence = (SocialUserClusterPersistence)socialUserPersistenceAPI;
                    socialUserClusterPersistence.sync(message.getUser());
                }
            });
        }
    }

    public void notify(SocialUser user) {
        if (!this.clusterService.isAppFormerClustered()) {
            return;
        }
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, (Serializable)new SocialUserClusterMessageWrapper(this.nodeId, user));
    }
}

