/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.security;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.service.SocialSecurityConstraint;

@ApplicationScoped
public class SocialSecurityConstraintsManager {
    @Inject
    private Instance<SocialSecurityConstraint> socialSecurityConstraints;

    public List<SocialActivitiesEvent> applyConstraints(List<SocialActivitiesEvent> events) {
        ArrayList<SocialActivitiesEvent> secureEvents = new ArrayList<SocialActivitiesEvent>();
        this.initConstraints();
        for (SocialActivitiesEvent event : events) {
            if (!this.isAllowed(event)) continue;
            secureEvents.add(event);
        }
        return secureEvents;
    }

    private void initConstraints() {
        for (SocialSecurityConstraint securityConstraint : this.getSocialSecurityConstraints()) {
            securityConstraint.init();
        }
    }

    boolean isAllowed(SocialActivitiesEvent event) {
        try {
            for (SocialSecurityConstraint securityConstraint : this.getSocialSecurityConstraints()) {
                if (!securityConstraint.hasRestrictions(event)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    Instance<SocialSecurityConstraint> getSocialSecurityConstraints() {
        return this.socialSecurityConstraints;
    }
}

