/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene62.Lucene62Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.model.KCluster;

public class DirectoryFactory
implements LuceneIndexFactory {
    private static final String REPOSITORIES_ROOT_DIR = ".index";
    private final Map<KCluster, LuceneIndex> clusters = new ConcurrentHashMap<KCluster, LuceneIndex>();
    private final DirectoryType type;
    private final Analyzer analyzer;

    public DirectoryFactory(DirectoryType type, Analyzer analyzer) {
        this.analyzer = analyzer;
        this.type = type;
        File[] files = DirectoryFactory.defaultHostingDir().listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                KClusterImpl cluster = new KClusterImpl(file.getName());
                this.clusters.put(cluster, type.newIndex(cluster, this.newConfig(analyzer)));
            }
        }
    }

    public static File defaultHostingDir() {
        String value = System.getProperty("org.uberfire.metadata.index.dir");
        if (value == null || value.trim().isEmpty()) {
            return new File(REPOSITORIES_ROOT_DIR);
        }
        return new File(value.trim(), REPOSITORIES_ROOT_DIR);
    }

    private IndexWriterConfig newConfig(Analyzer analyzer) {
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        Lucene62Codec codec = new Lucene62Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                if (field.equals("id")) {
                    return PostingsFormat.forName((String)"Memory");
                }
                return PostingsFormat.forName((String)"Lucene50");
            }
        };
        config.setCodec((Codec)codec);
        return config;
    }

    @Override
    public LuceneIndex newCluster(KCluster kcluster) {
        PortablePreconditions.checkCondition((String)"Cluster already exists", (!this.clusters.containsKey(PortablePreconditions.checkNotNull((String)"kcluster", (Object)kcluster)) ? 1 : 0) != 0);
        LuceneIndex newIndex = this.type.newIndex(kcluster, this.newConfig(this.analyzer));
        this.clusters.put(kcluster, newIndex);
        return newIndex;
    }

    @Override
    public void remove(KCluster cluster) {
        this.clusters.remove(cluster);
    }

    @Override
    public Map<? extends KCluster, ? extends LuceneIndex> getIndexes() {
        return Collections.unmodifiableMap(this.clusters);
    }

    public synchronized void dispose() {
        for (LuceneIndex luceneIndex : this.clusters.values()) {
            luceneIndex.dispose();
        }
    }
}

