/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.List;
import javax.inject.Inject;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class OrganizationalUnitFactoryImpl
implements OrganizationalUnitFactory {
    private RepositoryService repositoryService;
    private BackwardCompatibleUtil backward;
    private SpacesAPI spacesAPI;

    @Inject
    public OrganizationalUnitFactoryImpl(RepositoryService repositoryService, BackwardCompatibleUtil backward, SpacesAPI spacesAPI) {
        this.repositoryService = repositoryService;
        this.backward = backward;
        this.spacesAPI = spacesAPI;
    }

    public OrganizationalUnit newOrganizationalUnit(ConfigGroup groupConfig) {
        ConfigItem contributors;
        ConfigItem groups;
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(groupConfig.getName(), groupConfig.getConfigItemValue("owner"), groupConfig.getConfigItemValue("defaultGroupId"));
        ConfigItem repositories = groupConfig.getConfigItem("repositories");
        if (repositories != null) {
            for (Object alias : (List)repositories.getValue()) {
                Space space = this.spacesAPI.getSpace(organizationalUnit.getName());
                Repository repo = this.repositoryService.getRepositoryFromSpace(space, (String)alias);
                if (repo == null) continue;
                organizationalUnit.getRepositories().add(repo);
            }
        }
        if ((groups = this.backward.compat(groupConfig).getConfigItem("security:groups")) != null) {
            for (String group : (List)groups.getValue()) {
                organizationalUnit.getGroups().add(group);
            }
        }
        if ((contributors = groupConfig.getConfigItem("contributors")) != null) {
            for (String userName : (List)contributors.getValue()) {
                organizationalUnit.getContributors().add(userName);
            }
        }
        return organizationalUnit;
    }
}

