/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ToolConfig {
    private static final String HELP_HEADER = null;
    private static final String HELP_FOOTER = null;
    private static final String BATCH_SHORT = "b";
    private static final String BATCH_LONG = "batch";
    private static final String BATCH_DESCRIPTION = "Set this mode to ignore prompts. WARNING: you will not be prompted to make backups!";
    private static final String TARGET_SHORT = "t";
    private static final String TARGET_LONG = "target";
    private static final String TARGET_DESCRIPTION = "Target directory containing workbench projects and repositories being migrated.";
    private static final String TARGET_ARG_NAME = "DIRECTORY";
    private static final Options OPTIONS = new Options().addOption(Option.builder((String)"t").argName("DIRECTORY").longOpt("target").hasArg().numberOfArgs(1).desc("Target directory containing workbench projects and repositories being migrated.").required().build()).addOption(Option.builder((String)"b").longOpt("batch").hasArg(false).desc("Set this mode to ignore prompts. WARNING: you will not be prompted to make backups!").build());
    private CommandLine cli;

    public ToolConfig(CommandLine cli) {
        this.cli = cli;
    }

    public Path getTarget() {
        return Optional.ofNullable(this.cli.getOptionValue(TARGET_SHORT)).map(str -> Paths.get(str, new String[0]).toAbsolutePath().normalize()).orElseThrow(() -> new IllegalArgumentException("A target must be specified."));
    }

    public boolean isBatch() {
        return this.cli.hasOption(BATCH_SHORT);
    }

    public static ToolConfig parse(String[] args) throws ParseException {
        Options opts = OPTIONS;
        return new ToolConfig(new DefaultParser().parse(opts, args));
    }

    public static void printHelp(PrintStream stream, String app) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(new PrintWriter(System.err, true), formatter.getWidth(), app, HELP_HEADER, OPTIONS, formatter.getLeftPadding(), formatter.getDescPadding(), HELP_FOOTER, true);
    }

    public static class DefaultFactory
    implements ToolConfigFactory {
        @Override
        public ToolConfig parse(String[] args) throws ParseException {
            return ToolConfig.parse(args);
        }

        @Override
        public void printHelp(PrintStream stream, String app) {
            ToolConfig.printHelp(stream, app);
        }
    }

    public static interface ToolConfigFactory {
        public ToolConfig parse(String[] var1) throws ParseException;

        public void printHelp(PrintStream var1, String var2);
    }
}

