/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationEnvironmentStrategy;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationKey;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationPropertiesStrategy;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationProvider;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationStaticStrategy;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationStrategy;

public class ConfigurationContextProvider
implements ConfigurationProvider {
    private Map<ConfigurationKey, String> conf;

    public ConfigurationContextProvider() {
        this.initializeWorkingConfig();
    }

    private void initializeWorkingConfig() {
        ArrayList<ConfigurationStrategy> confs = new ArrayList<ConfigurationStrategy>(Arrays.asList(new ConfigurationEnvironmentStrategy(), new ConfigurationPropertiesStrategy(), new ConfigurationStaticStrategy()));
        Collections.sort(confs, (one, two) -> one.getOrder().compareTo(two.getOrder()));
        for (ConfigurationStrategy item : confs) {
            if (!item.isValid().booleanValue()) continue;
            this.conf = item.loadConfiguration();
            break;
        }
    }

    @Override
    public Map<ConfigurationKey, String> loadConfiguration() {
        return this.conf;
    }
}

