/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.decorators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.core.rule.KieModuleMetaInfo;
import org.kie.api.builder.KieModule;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.KieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultKieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.nio.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.CompilerDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.ClassLoaderProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieAfterDecorator<T extends CompilationResponse, C extends AFCompiler<T>>
implements CompilerDecorator {
    private static final Logger logger = LoggerFactory.getLogger(KieAfterDecorator.class);
    private C compiler;

    public KieAfterDecorator(C compiler) {
        this.compiler = compiler;
    }

    @Override
    public T compileSync(CompilationRequest req) {
        Object res = this.compiler.compileSync(req);
        if (res.isSuccessful().booleanValue() && req.getInfo().isKiePluginPresent().booleanValue()) {
            return (T)this.handleKieMavenPlugin(req, (CompilationResponse)res);
        }
        return res;
    }

    @Override
    public T buildDefaultCompilationResponse(Boolean value) {
        return this.compiler.buildDefaultCompilationResponse(value);
    }

    @Override
    public T buildDefaultCompilationResponse(Boolean value, List output) {
        return this.compiler.buildDefaultCompilationResponse(value);
    }

    private KieCompilationResponse handleKieMavenPlugin(CompilationRequest req, CompilationResponse res) {
        KieTuple kieModuleMetaInfoTuple = this.readKieModuleMetaInfo(req);
        KieTuple kieModuleTuple = this.readKieModule(req);
        if (kieModuleMetaInfoTuple.getOptionalObject().isPresent() && kieModuleTuple.getOptionalObject().isPresent()) {
            ClassLoaderProviderImpl provider = new ClassLoaderProviderImpl();
            Optional<List<URI>> optionalDeps = provider.getURISFromAllDependencies(req.getInfo().getPrjPath().toAbsolutePath().toString());
            List<URI> uris = Collections.emptyList();
            if (optionalDeps.isPresent()) {
                uris = optionalDeps.get();
            }
            if (req.getKieCliRequest().isLogRequested().booleanValue()) {
                return new DefaultKieCompilationResponse(Boolean.TRUE, (KieModuleMetaInfo)kieModuleMetaInfoTuple.getOptionalObject().get(), (KieModule)kieModuleTuple.getOptionalObject().get(), res.getMavenOutput().get(), uris);
            }
            return new DefaultKieCompilationResponse(Boolean.TRUE, (KieModuleMetaInfo)kieModuleMetaInfoTuple.getOptionalObject().get(), (KieModule)kieModuleTuple.getOptionalObject().get(), uris);
        }
        StringBuilder sb = new StringBuilder();
        if (kieModuleMetaInfoTuple.getErrorMsg().isPresent()) {
            sb.append(" Error in the kieModuleMetaInfo from the kieMap:").append(kieModuleMetaInfoTuple.getErrorMsg().get());
        }
        if (kieModuleTuple.getErrorMsg().isPresent()) {
            sb.append(" Error in the kieModule:").append(kieModuleTuple.getErrorMsg().get());
        }
        if (req.getKieCliRequest().isLogRequested().booleanValue()) {
            return new DefaultKieCompilationResponse(Boolean.FALSE, sb.toString(), res.getMavenOutput().get());
        }
        return new DefaultKieCompilationResponse(Boolean.FALSE, sb.toString());
    }

    private KieTuple readKieModuleMetaInfo(CompilationRequest req) {
        StringBuilder sb = new StringBuilder(req.getKieCliRequest().getRequestUUID()).append(".").append(KieModuleMetaInfo.class.getName());
        Object o = req.getKieCliRequest().getMap().get(sb.toString());
        if (o != null) {
            KieTuple tuple = this.readObjectFromADifferentClassloader(o);
            if (tuple.getOptionalObject().isPresent()) {
                return new KieTuple(tuple.getOptionalObject().get());
            }
            return new KieTuple(tuple.getErrorMsg());
        }
        return new KieTuple("kieModuleMetaInfo not present in the map");
    }

    private KieTuple readKieModule(CompilationRequest req) {
        StringBuilder sb = new StringBuilder(req.getKieCliRequest().getRequestUUID()).append(".").append(FileKieModule.class.getName());
        Object o = req.getKieCliRequest().getMap().get(sb.toString());
        if (o != null) {
            KieTuple tuple = this.readObjectFromADifferentClassloader(o);
            if (tuple.getOptionalObject().isPresent()) {
                return new KieTuple(tuple.getOptionalObject().get());
            }
            return new KieTuple(tuple.getErrorMsg());
        }
        return new KieTuple("kieModule not present in the map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieTuple readObjectFromADifferentClassloader(Object o) {
        ObjectInput in = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.flush();
            byte[] objBytes = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(objBytes);
            in = new ObjectInputStream(bis);
            Object newObj = in.readObject();
            KieTuple kieTuple = new KieTuple(newObj);
            return kieTuple;
        }
        catch (NotSerializableException nse) {
            nse.printStackTrace();
            StringBuilder sb = new StringBuilder("NotSerializableException:").append(nse.getMessage());
            KieTuple kieTuple = new KieTuple(sb.toString());
            return kieTuple;
        }
        catch (IOException ioe) {
            StringBuilder sb = new StringBuilder("IOException:").append(ioe.getMessage());
            KieTuple kieTuple = new KieTuple(sb.toString());
            return kieTuple;
        }
        catch (ClassNotFoundException cnfe) {
            StringBuilder sb = new StringBuilder("ClassNotFoundException:").append(cnfe.getMessage());
            KieTuple kieTuple = new KieTuple(sb.toString());
            return kieTuple;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Exception:").append(e.getMessage());
            KieTuple kieTuple = new KieTuple(sb.toString());
            return kieTuple;
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    static class KieTuple {
        private Object optionalObj;
        private String errorMsg;

        public KieTuple(Object optionalObj) {
            this.optionalObj = optionalObj;
        }

        public KieTuple(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public Optional<Object> getOptionalObject() {
            return Optional.ofNullable(this.optionalObj);
        }

        public Optional<String> getErrorMsg() {
            return Optional.ofNullable(this.errorMsg);
        }
    }
}

