/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.kmodule;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.kmodule.KModuleContentHandler;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class KModuleServiceImpl
implements KModuleService {
    private IOService ioService;
    private KieModuleService moduleService;
    private MetadataService metadataService;
    private KModuleContentHandler moduleContentHandler;

    public KModuleServiceImpl() {
    }

    @Inject
    public KModuleServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, MetadataService metadataService, KModuleContentHandler moduleContentHandler) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.metadataService = metadataService;
        this.moduleContentHandler = moduleContentHandler;
    }

    protected void setModuleService(KieModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public boolean isKModule(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            KieModule module = (KieModule)this.moduleService.resolveModule(resource);
            if (module == null) {
                return false;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path kmoduleFilePath = Paths.convert((org.uberfire.backend.vfs.Path)module.getKModuleXMLPath());
            return path.startsWith(kmoduleFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path setUpKModule(org.uberfire.backend.vfs.Path path) {
        try {
            Path pathToKModuleXML = Paths.convert((org.uberfire.backend.vfs.Path)path);
            if (this.ioService.exists(pathToKModuleXML)) {
                throw new FileAlreadyExistsException(pathToKModuleXML.toString());
            }
            this.ioService.write(pathToKModuleXML, this.moduleContentHandler.toString(new KModuleModel()), new OpenOption[0]);
            return Paths.convert((Path)pathToKModuleXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public KModuleModel load(org.uberfire.backend.vfs.Path path) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String content = this.ioService.readAllString(nioPath);
            return this.moduleContentHandler.toModel(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, KModuleModel content, Metadata metadata, String comment) {
        try {
            if (metadata == null) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.moduleContentHandler.toString(content), new OpenOption[0]);
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.moduleContentHandler.toString(content), this.metadataService.setUpAttributes(path, metadata), new OpenOption[0]);
            }
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

