/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.project.model.Module;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.core.LRUModuleDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.MapClassLoader;
import org.kie.workbench.common.services.shared.project.KieModule;

@ApplicationScoped
public class ModuleClassLoaderHelper {
    @Inject
    private BuildInfoService buildInfoService;
    @Inject
    @Named(value="LRUModuleDependenciesClassLoaderCache")
    private LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache;

    public ClassLoader getModuleClassLoader(KieModule kieModule) {
        ClassLoader moduleClassLoader;
        org.kie.api.builder.KieModule module = this.buildInfoService.getBuildInfo((Module)kieModule).getKieModuleIgnoringErrors();
        ClassLoader dependenciesClassLoader = this.dependenciesClassLoaderCache.assertDependenciesClassLoader(kieModule);
        if (module instanceof InternalKieModule) {
            InternalKieModule internalModule = (InternalKieModule)module;
            moduleClassLoader = new MapClassLoader(internalModule.getClassesMap(true), dependenciesClassLoader);
        } else {
            moduleClassLoader = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)module).getClassLoader();
        }
        return moduleClassLoader;
    }
}

