/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.events.NewModuleEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.services.backend.project.KieResourceResolver;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;

public class ModuleSaver {
    private IOService ioService;
    private POMService pomService;
    private KModuleService kModuleService;
    private Event<NewModuleEvent> newModuleEvent;
    private Event<NewPackageEvent> newPackageEvent;
    private KieResourceResolver resourceResolver;
    private ProjectImportsService projectImportsService;
    private ModuleRepositoriesService moduleRepositoriesService;
    private PackageNameWhiteListService packageNameWhiteListService;
    private CommentedOptionFactory commentedOptionFactory;
    private SafeSessionInfo safeSessionInfo;

    public ModuleSaver() {
    }

    @Inject
    public ModuleSaver(@Named(value="ioStrategy") IOService ioService, POMService pomService, KModuleService kModuleService, Event<NewModuleEvent> newModuleEvent, Event<NewPackageEvent> newPackageEvent, KieResourceResolver resourceResolver, ProjectImportsService projectImportsService, ModuleRepositoriesService moduleRepositoriesService, PackageNameWhiteListService packageNameWhiteListService, CommentedOptionFactory commentedOptionFactory, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.newModuleEvent = newModuleEvent;
        this.newPackageEvent = newPackageEvent;
        this.resourceResolver = resourceResolver;
        this.projectImportsService = projectImportsService;
        this.moduleRepositoriesService = moduleRepositoriesService;
        this.packageNameWhiteListService = packageNameWhiteListService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public KieModule save(org.uberfire.backend.vfs.Path repositoryRoot, POM pom, String baseUrl) {
        try {
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot).getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption("New module [" + pom.getName() + "]")});
            KieModule kieModule = new NewModuleCreator(pom, repositoryRoot).create(baseUrl);
            this.newModuleEvent.fire((Object)new NewModuleEvent((Module)kieModule, this.safeSessionInfo.getId(), this.safeSessionInfo.getIdentity().getIdentifier()));
            KieModule kieModule2 = kieModule;
            return kieModule2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private class NewModuleCreator {
        private final org.uberfire.backend.vfs.Path moduleRoot;
        private final POM pom;
        private final KieModule simpleModuleInstance;

        public NewModuleCreator(POM pom, org.uberfire.backend.vfs.Path moduleRoot) {
            this.moduleRoot = moduleRoot;
            this.pom = pom;
            this.simpleModuleInstance = ModuleSaver.this.resourceResolver.simpleModuleInstance(Paths.convert((org.uberfire.backend.vfs.Path)moduleRoot));
        }

        public KieModule create(String baseUrl) {
            this.createModule(baseUrl);
            return ModuleSaver.this.resourceResolver.resolveModule(this.moduleRoot);
        }

        private void createModule(String baseUrl) {
            this.checkIfExists();
            this.updateParentPOM();
            ModuleSaver.this.pomService.create(this.moduleRoot, baseUrl, this.pom);
            this.createMavenDirectories();
            ModuleSaver.this.kModuleService.setUpKModule(this.simpleModuleInstance.getKModuleXMLPath());
            this.createDefaultPackage();
            ModuleSaver.this.projectImportsService.saveProjectImports(this.simpleModuleInstance.getImportsPath());
            ModuleSaver.this.packageNameWhiteListService.createModuleWhiteList(this.simpleModuleInstance.getPackageNamesWhiteListPath());
            ModuleSaver.this.moduleRepositoriesService.create(this.simpleModuleInstance.getRepositoriesPath());
        }

        private void checkIfExists() {
            Path pathToModulePom = Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("pom.xml");
            if (ModuleSaver.this.ioService.exists(pathToModulePom)) {
                throw new FileAlreadyExistsException(pathToModulePom.toString());
            }
        }

        private void updateParentPOM() {
            org.uberfire.backend.vfs.Path parentPom = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("pom.xml"));
            if (ModuleSaver.this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)parentPom))) {
                POM parent = (POM)ModuleSaver.this.pomService.load(parentPom);
                parent.setPackaging("pom");
                parent.getModules().add(this.pom.getName());
                this.pom.setParent(parent.getGav());
                ModuleSaver.this.pomService.save(parentPom, (Object)parent, null, "Adding child module " + this.pom.getName());
            }
        }

        private void createMavenDirectories() {
            ModuleSaver.this.ioService.createDirectory(Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("src/main/java"), new FileAttribute[0]);
            ModuleSaver.this.ioService.createDirectory(Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("src/main/resources"), new FileAttribute[0]);
            ModuleSaver.this.ioService.createDirectory(Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("src/test/java"), new FileAttribute[0]);
            ModuleSaver.this.ioService.createDirectory(Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("src/test/resources"), new FileAttribute[0]);
        }

        private void createDefaultPackage() {
            ModuleSaver.this.newPackageEvent.fire((Object)new NewPackageEvent(ModuleSaver.this.resourceResolver.newPackage(this.getDefaultPackage(), ModuleSaver.this.resourceResolver.getDefaultWorkspacePath(this.pom.getGav()), false)));
        }

        private Package getDefaultPackage() {
            return ModuleSaver.this.resourceResolver.resolvePackage(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.moduleRoot).resolve("src/main/resources")));
        }
    }
}

