/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class ClientEditorActivityGenerator
extends AbstractGenerator {
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String onStartup1ParameterMethodName;
        String onStartup0ParameterMethodName;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String annotationName = ClientAPIModule.getWorkbenchClientEditorClass();
        boolean isDynamic = ClientAPIModule.getWbEditorIsDynamicValueOnClass(classElement);
        String identifier = null;
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                AnnotationValue aval = entry.getValue();
                if (!"identifier".equals(entry.getKey().getSimpleName().toString())) continue;
                identifier = aval.getValue().toString();
            }
        }
        String beanActivatorClass = GeneratorUtils.getBeanActivatorClassName(classElement, processingEnvironment);
        ExecutableElement executableElement = GeneratorUtils.getOnStartupMethodForNonEditors(classElement, processingEnvironment);
        if (executableElement == null) {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = null;
        } else if (executableElement.getParameters().isEmpty()) {
            onStartup0ParameterMethodName = executableElement.getSimpleName().toString();
            onStartup1ParameterMethodName = null;
        } else {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = executableElement.getSimpleName().toString();
        }
        String onMayCloseMethodName = GeneratorUtils.getOnMayCloseMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String onLostFocusMethodName = GeneratorUtils.getOnLostFocusMethodName(classElement, processingEnvironment);
        String onFocusMethodName = GeneratorUtils.getOnFocusMethodName(classElement, processingEnvironment);
        String getDefaultPositionMethodName = GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        String getContextIdMethodName = GeneratorUtils.getContextIdMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean isWidgetMethodReturnTypeElement = getWidgetMethod != null && GeneratorUtils.getIsElement(getWidgetMethod.getReturnType(), processingEnvironment);
        boolean hasUberView = GeneratorUtils.hasPresenterInitMethod(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String isDirtyMethodName = GeneratorUtils.getIsDirtyMethodName(classElement, processingEnvironment);
        ExecutableElement setContentMethod = GeneratorUtils.getSetContentMethodName(classElement, processingEnvironment);
        String setContentMethodName = setContentMethod == null ? null : setContentMethod.getSimpleName().toString();
        ExecutableElement getContentMethod = GeneratorUtils.getGetContentMethodName(classElement, processingEnvironment);
        String getContentMethodName = getContentMethod == null ? null : getContentMethod.getSimpleName().toString();
        ExecutableElement getPreviewMethod = GeneratorUtils.getGetPreviewMethodName(classElement, processingEnvironment);
        String getPreviewMethodName = getPreviewMethod == null ? null : getPreviewMethod.getSimpleName().toString();
        ExecutableElement validateMethod = GeneratorUtils.getValidateMethodName(classElement, processingEnvironment);
        String validateMethodName = validateMethod == null ? null : validateMethod.getSimpleName().toString();
        List<String> qualifiers = GeneratorUtils.getAllQualifiersDeclarationFromType(classElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "getContextIdMethodName: " + getContextIdMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onMayCloseMethodName: " + onMayCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onCloseMethodName: " + onCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onShutdownMethodName: " + onShutdownMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onLostFocusMethodName: " + onLostFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onFocusMethodName: " + onFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getDefaultPositionMethodName: " + getDefaultPositionMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleMethodName: " + getTitleMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleWidgetMethodName: " + getTitleWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getWidgetMethodName: " + getWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidgetMethodReturnTypeElement: " + isWidgetMethodReturnTypeElement);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidget: " + Boolean.toString(isWidget));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberView: " + Boolean.toString(hasUberView));
            messager.printMessage(Diagnostic.Kind.NOTE, "setContentMethodName: " + setContentMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getContentMethodName: " + getContentMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getPreviewMethodName: " + getPreviewMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isDirtyMethodName: " + isDirtyMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "validateMethodName: " + validateMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Qualifiers: " + String.join((CharSequence)", ", qualifiers));
        }
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchClientEditor must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            String msg = "The WorkbenchClientEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            messager.printMessage(Diagnostic.Kind.WARNING, "The WorkbenchClientEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.", classElement);
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchClientEditor must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        if (setContentMethodName == null) {
            throw new GenerationException("org.uberfire.annotations.processors.WorkbenchClientEditorTest4Activity: The WorkbenchClientEditor must provide a @SetContent annotated method that has two java.lang.String (path and content) as parameters.", packageName + "." + className);
        }
        if (getContentMethodName == null) {
            throw new GenerationException("The WorkbenchClientEditor must provide a @GetContent annotated method to return a elemental2.promise.Promise.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("getContextIdMethodName", getContextIdMethodName);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("beanActivatorClass", beanActivatorClass);
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onMayCloseMethodName", onMayCloseMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("onLostFocusMethodName", onLostFocusMethodName);
        root.put("onFocusMethodName", onFocusMethodName);
        root.put("getDefaultPositionMethodName", getDefaultPositionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidgetMethodReturnTypeElement", isWidgetMethodReturnTypeElement);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("isDirtyMethodName", isDirtyMethodName);
        root.put("setContentMethodName", setContentMethodName);
        root.put("getContentMethodName", getContentMethodName);
        root.put("getPreviewMethodName", getPreviewMethodName);
        root.put("isDynamic", isDynamic);
        root.put("validateMethodName", validateMethodName);
        root.put("qualifiers", qualifiers);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("activityClientEditor.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

