/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu.megamenu.menuitem;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.IconMenuItemPresenter;
import org.uberfire.mvp.Command;

@Templated
public class IconMenuItemView
implements IsElement,
IconMenuItemPresenter.View {
    private IconMenuItemPresenter presenter;
    @Inject
    @DataField(value="item")
    Anchor item;
    @Inject
    @DataField(value="icon")
    Span icon;

    public void init(IconMenuItemPresenter presenter) {
        this.presenter = presenter;
    }

    public void setIconClass(String iconClass) {
        if (iconClass != null && !iconClass.isEmpty()) {
            Stream.of(iconClass.split(" ")).forEach(clazz -> this.icon.getClassList().add(clazz));
        }
    }

    public void setLabel(String label) {
        this.item.setTitle(label);
    }

    public void setCommand(Command command) {
        this.item.setOnclick(event -> command.execute());
    }

    public void enable() {
        this.item.removeAttribute("disabled");
    }

    public void disable() {
        this.item.setAttribute("disabled", "disabled");
    }

    public void select() {
        this.item.getClassList().add("active");
    }
}

