/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.migration.cli.maven;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import org.apache.maven.model.Model;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.migration.cli.MigrationServicesCDIWrapper;
import org.kie.workbench.common.project.migration.cli.maven.PomMigrationEditor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;

public class PomEditorWithGitTest {
    private FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private IOService ioService;
    private PomMigrationEditor editor;
    private WeldContainer weldContainer;
    private MigrationServicesCDIWrapper cdiWrapper;

    @Before
    public void setUp() throws Exception {
        this.weldContainer = new Weld().initialize();
        this.cdiWrapper = (MigrationServicesCDIWrapper)this.weldContainer.instance().select(MigrationServicesCDIWrapper.class, new Annotation[0]).get();
        this.fileSystemTestingUtils.setup();
        this.ioService = this.fileSystemTestingUtils.getIoService();
        this.editor = new PomMigrationEditor();
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystemTestingUtils.cleanup();
        if (this.weldContainer != null) {
            this.weldContainer.close();
        }
    }

    @Test
    public void testPomEditor() throws Exception {
        String repoName = "myrepoxxxx";
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("init", Boolean.TRUE);
        env.put("internal", Boolean.TRUE);
        JGitFileSystem fs = (JGitFileSystem)this.ioService.newFileSystem(URI.create("git://myrepoxxxx"), env);
        this.ioService.startBatch((FileSystem)fs);
        this.ioService.write(fs.getPath("/pom.xml", new String[0]), new String(Files.readAllBytes(new File("src/test/projects/generic/pom.xml").toPath())), new OpenOption[0]);
        this.ioService.endBatch();
        Path tmpCloned = org.uberfire.java.nio.file.Files.createTempDirectory((String)"cloned", (FileAttribute[])new FileAttribute[0]);
        File gitClonedFolder = new File(tmpCloned.toFile(), ".clone.git");
        Git cloned = Git.cloneRepository().setURI(fs.getGit().getRepository().getDirectory().toURI().toString()).setBare(false).setDirectory(gitClonedFolder).call();
        Assert.assertNotNull((Object)cloned);
        Path pomPath = Paths.get((String)("file://" + gitClonedFolder.toString() + "/pom.xml"), (String[])new String[0]);
        byte[] encoded = org.uberfire.java.nio.file.Files.readAllBytes((Path)pomPath);
        String pomOriginal = new String(encoded, StandardCharsets.UTF_8);
        Model model = this.editor.updatePom(pomPath, this.cdiWrapper);
        Assert.assertNotNull((Object)model);
        PullCommand pc = cloned.pull().setRemote("origin").setRebase(Boolean.TRUE.booleanValue());
        PullResult pullRes = pc.call();
        Assert.assertEquals((Object)pullRes.getRebaseResult().getStatus(), (Object)RebaseResult.Status.UP_TO_DATE);
        RebaseCommand rb = cloned.rebase().setUpstream("origin/master");
        RebaseResult rbResult = rb.setPreserveMerges(true).call();
        Assert.assertTrue((boolean)rbResult.getStatus().isSuccessful());
        pomPath = Paths.get((String)("file://" + gitClonedFolder.toString() + "/pom.xml"), (String[])new String[0]);
        encoded = org.uberfire.java.nio.file.Files.readAllBytes((Path)pomPath);
        String pomUpdated = new String(encoded, StandardCharsets.UTF_8);
        Assert.assertFalse((boolean)pomOriginal.equals(pomUpdated));
    }
}

