/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InternalMigrationServiceTest {
    @Test
    public void testGetOrgUnitsByRepo() {
        String repo1Name = "repo1";
        String repo2Name = "repo2";
        String repo3Name = "repo3";
        String space1Name = "space1";
        String space2Name = "space2";
        int numberOfRepositories = 3;
        ArrayList<ConfigGroup> ouConfigs = new ArrayList<ConfigGroup>();
        List<String> space1Repos = Arrays.asList("repo1", "repo2");
        List<String> space2Repos = Arrays.asList("repo3");
        ConfigItem space1Config = new ConfigItem();
        space1Config.setName("repositories");
        space1Config.setValue(space1Repos);
        ConfigItem space2Config = new ConfigItem();
        space2Config.setName("repositories");
        space2Config.setValue(space2Repos);
        ConfigGroup space1 = new ConfigGroup();
        space1.setConfigItem(space1Config);
        space1.setName("space1");
        ConfigGroup space2 = new ConfigGroup();
        space2.setConfigItem(space2Config);
        space2.setName("space2");
        ouConfigs.add(space1);
        ouConfigs.add(space2);
        Map orgUnitsByRepo = InternalMigrationService.getOrgUnitsByRepo(ouConfigs);
        Assert.assertEquals((long)3L, (long)orgUnitsByRepo.size());
        Assert.assertEquals((Object)"space1", orgUnitsByRepo.get("repo1"));
        Assert.assertEquals((Object)"space1", orgUnitsByRepo.get("repo2"));
        Assert.assertEquals((Object)"space2", orgUnitsByRepo.get("repo3"));
    }

    @Test
    public void testCreateSpaceDirs() {
        String firstOuName = "firstOrgUnit";
        String secondOuName = "secondOrgUnit";
        int expectedCreatedDirs = 2;
        ConfigGroup firstOuConfig = new ConfigGroup();
        firstOuConfig.setName("firstOrgUnit");
        ConfigGroup secondOuConfig = new ConfigGroup();
        secondOuConfig.setName("secondOrgUnit");
        ArrayList<ConfigGroup> orgUnitConfigs = new ArrayList<ConfigGroup>();
        orgUnitConfigs.add(firstOuConfig);
        orgUnitConfigs.add(secondOuConfig);
        Path mockPath = (Path)Mockito.mock(Path.class);
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockPath.toFile()).thenReturn((Object)mockFile);
        Mockito.when((Object)mockPath.resolve(Matchers.anyString())).thenReturn((Object)mockPath);
        InternalMigrationService.createSpaceDirs((Path)mockPath, orgUnitConfigs);
        ((Path)Mockito.verify((Object)mockPath)).resolve("firstOrgUnit");
        ((Path)Mockito.verify((Object)mockPath)).resolve("secondOrgUnit");
        ((File)Mockito.verify((Object)mockFile, (VerificationMode)Mockito.times((int)2))).mkdir();
    }
}

