/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.kie.workbench.common.project.config.MigrationRepositoryServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectMigrationServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectServiceImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.spaces.Space;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InternalMigrationService.class})
public class MigrateAllProjectsTest {
    private static final String PROJECT_A = "projectA";
    private static final String PROJECT_B = "projectB";
    private static final String PROJECT_C = "projectC";
    private static final String PROJECT_D = "projectD";
    private static final String REPO_A = "repoA";
    private static final String REPO_B = "repoB";
    private static final String REPO_C = "repoC";
    private static final String SPACE_A = "spaceA";
    private static final String SPACE_B = "spaceB";
    private static final int NUMBER_OF_REPOS = 3;
    @Mock
    private MigrationWorkspaceProjectServiceImpl projectService;
    @Mock
    private MigrationConfigurationServiceImpl configService;
    @Mock
    private MigrationWorkspaceProjectMigrationServiceImpl projectMigrationService;
    @Mock
    private MigrationRepositoryServiceImpl repoService;
    @Mock
    private SystemAccess system;
    @InjectMocks
    private InternalMigrationService service;

    public List<ConfigGroup> initConfigGroups() {
        ArrayList<ConfigGroup> spaceConfigs = new ArrayList<ConfigGroup>();
        List<String> spaceARepos = Arrays.asList(REPO_A);
        List<String> spaceBRepos = Arrays.asList(REPO_B, REPO_C);
        ConfigItem spaceAConfig = new ConfigItem();
        spaceAConfig.setName("repositories");
        spaceAConfig.setValue(spaceARepos);
        ConfigItem spaceBConfig = new ConfigItem();
        spaceBConfig.setName("repositories");
        spaceBConfig.setValue(spaceBRepos);
        ConfigGroup spaceA = new ConfigGroup();
        spaceA.setConfigItem(spaceAConfig);
        spaceA.setName(SPACE_A);
        ConfigGroup spaceB = new ConfigGroup();
        spaceB.setConfigItem(spaceBConfig);
        spaceB.setName(SPACE_B);
        spaceConfigs.add(spaceA);
        spaceConfigs.add(spaceB);
        return spaceConfigs;
    }

    private Repository mockRepo(String name) {
        Repository repo = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo.getAlias()).thenReturn((Object)name);
        return repo;
    }

    private WorkspaceProject mockProject(String name, Repository repository) {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Mockito.when((Object)project.getName()).thenReturn((Object)name);
        Mockito.when((Object)project.getRepository()).thenReturn((Object)repository);
        return project;
    }

    private List<WorkspaceProject> initWorkspaceProjects() {
        ArrayList<WorkspaceProject> workspaceProjects = new ArrayList<WorkspaceProject>();
        Repository repoA = this.mockRepo(REPO_A);
        Repository repoB = this.mockRepo(REPO_B);
        Repository repoC = this.mockRepo(REPO_C);
        WorkspaceProject projectA = this.mockProject(PROJECT_A, repoA);
        WorkspaceProject projectB = this.mockProject(PROJECT_B, repoA);
        WorkspaceProject projectC = this.mockProject(PROJECT_C, repoB);
        WorkspaceProject projectD = this.mockProject(PROJECT_D, repoC);
        workspaceProjects.add(projectA);
        workspaceProjects.add(projectB);
        workspaceProjects.add(projectC);
        workspaceProjects.add(projectD);
        return workspaceProjects;
    }

    @Test
    public void testMigrateAllProjects() throws Exception {
        List<ConfigGroup> spaceConfigs = this.initConfigGroups();
        List<WorkspaceProject> workspaceProjects = this.initWorkspaceProjects();
        PowerMockito.mockStatic(Files.class, (Class[])new Class[0]);
        Path niogitDir = (Path)Mockito.mock(Path.class);
        File niogitDirFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)Files.move((Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), new CopyOption[0])).thenReturn((Object)niogitDir);
        Mockito.when((Object)this.projectService.getAllWorkspaceProjects()).thenReturn(workspaceProjects);
        Mockito.when((Object)this.system.out()).thenReturn((Object)System.out);
        Mockito.when((Object)this.configService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT)).thenReturn(spaceConfigs);
        Mockito.when((Object)this.configService.getConfiguration(ConfigType.REPOSITORY)).thenReturn(spaceConfigs);
        Mockito.when((Object)niogitDir.toFile()).thenReturn((Object)niogitDirFile);
        Mockito.when((Object)niogitDir.resolve(Matchers.anyString())).thenReturn((Object)niogitDir);
        this.service.migrateAllProjects(niogitDir);
        PowerMockito.verifyStatic((VerificationMode)Mockito.times((int)3));
        Files.move((Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), new CopyOption[0]);
        ((MigrationWorkspaceProjectMigrationServiceImpl)Mockito.verify((Object)this.projectMigrationService, (VerificationMode)Mockito.times((int)workspaceProjects.size()))).migrate((WorkspaceProject)Matchers.any(WorkspaceProject.class));
        ((MigrationRepositoryServiceImpl)Mockito.verify((Object)this.repoService, (VerificationMode)Mockito.times((int)3))).removeRepository((Space)Matchers.any(), Matchers.anyString());
    }
}

