/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;

@Dependent
public class ConfigGroupToSpaceInfoConverter {
    private static final String PROPOSED_GROUP_ID_REGEX = "[^A-Za-z0-9_\\-.]";
    private static final String DEFAULT_GROUP_ID = "defaultGroupId";
    private static final String OWNER = "owner";
    private static final String CONTRIBUTORS = "contributors";
    private static final String SPACE_CONTRIBUTORS = "space-contributors";
    private static final String SECURITY_GROUPS = "security:groups";
    private ConfigurationService configurationService;
    private BackwardCompatibleUtil backwardCompatibleUtil;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    @Inject
    public ConfigGroupToSpaceInfoConverter(ConfigurationService configurationService, BackwardCompatibleUtil backwardCompatibleUtil, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        this.configurationService = configurationService;
        this.backwardCompatibleUtil = backwardCompatibleUtil;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
    }

    public SpaceInfo toSpaceInfo(ConfigGroup configGroup) {
        String spaceName = this.extractName(configGroup);
        Optional<SpaceInfo> optional = Optional.ofNullable(this.spaceConfigStorageRegistry.get(spaceName).loadSpaceInfo());
        if (optional.isPresent()) {
            return optional.get();
        }
        String defaultGroupId = this.extractDefaultGroupId(configGroup);
        Collection<Contributor> contributors = this.extractContributors(configGroup);
        List<RepositoryInfo> repositories = this.extractRepositories(spaceName);
        List<String> securityGroups = this.extractSecurityGroups(configGroup);
        return new SpaceInfo(spaceName, defaultGroupId, contributors, repositories, securityGroups);
    }

    private String extractName(ConfigGroup groupConfig) {
        return groupConfig.getName();
    }

    private String extractDefaultGroupId(ConfigGroup groupConfig) {
        String defaultGroupId = groupConfig.getConfigItemValue(DEFAULT_GROUP_ID);
        if (defaultGroupId == null || defaultGroupId.trim().isEmpty()) {
            defaultGroupId = this.getSanitizedDefaultGroupId(this.extractName(groupConfig));
        }
        return defaultGroupId;
    }

    private String getSanitizedDefaultGroupId(String proposedGroupId) {
        return proposedGroupId != null ? proposedGroupId.replaceAll(PROPOSED_GROUP_ID_REGEX, "") : proposedGroupId;
    }

    private Collection<Contributor> extractContributors(ConfigGroup configGroup) {
        ConfigItem oldContributors;
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        boolean oldConfigGroup = false;
        String oldOwner = configGroup.getConfigItemValue(OWNER);
        if (oldOwner != null) {
            oldConfigGroup = true;
            contributors.add(new Contributor(oldOwner, ContributorType.OWNER));
        }
        if ((oldContributors = configGroup.getConfigItem(CONTRIBUTORS)) != null) {
            oldConfigGroup = true;
            for (String userName : (List)oldContributors.getValue()) {
                if (userName.equals(oldOwner)) continue;
                contributors.add(new Contributor(userName, ContributorType.CONTRIBUTOR));
            }
        }
        if (!oldConfigGroup) {
            ConfigItem newContributorsConfigItem = configGroup.getConfigItem(SPACE_CONTRIBUTORS);
            contributors.addAll((Collection)newContributorsConfigItem.getValue());
        }
        return contributors;
    }

    private List<RepositoryInfo> extractRepositories(String spaceName) {
        List repos = this.configurationService.getConfiguration(ConfigType.REPOSITORY, spaceName);
        return repos.stream().map(this::toRepositoryInfo).collect(Collectors.toList());
    }

    private RepositoryInfo toRepositoryInfo(ConfigGroup configGroup) {
        Map<String, Object> environment = this.backwardCompatibleUtil.compat(configGroup).getItems().stream().collect(Collectors.toMap(item -> item.getName(), item -> item.getValue()));
        return new RepositoryInfo(configGroup.getName(), false, new RepositoryConfiguration(environment));
    }

    private List<String> extractSecurityGroups(ConfigGroup groupConfig) {
        ConfigItem securityGroups = this.backwardCompatibleUtil.compat(groupConfig).getConfigItem(SECURITY_GROUPS);
        return (List)securityGroups.getValue();
    }
}

