/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.guvnor.common.services.project.project.WorkspaceProjectMigrationService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.kie.workbench.common.project.config.MigrationRepositoryServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectMigrationServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class InternalMigrationServiceTest {
    private static final String SPACE_CONTRIBUTORS = "space-contributors";
    private static final String SECURITY_GROUPS = "security:groups";
    @Mock
    private MigrationWorkspaceProjectServiceImpl projectService;
    @Mock
    private MigrationConfigurationServiceImpl configService;
    @Mock
    private MigrationWorkspaceProjectMigrationServiceImpl projectMigrationService;
    @Mock
    private MigrationRepositoryServiceImpl repoService;
    @Mock
    private SystemAccess system;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private BackwardCompatibleUtil backwardCompatibleUtil;
    private InternalMigrationService internalMigrationService;

    @Before
    public void init() {
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(ArgumentMatchers.anyString())).thenReturn((Object)this.spaceConfigStorage);
        Mockito.when((Object)this.backwardCompatibleUtil.compat((ConfigGroup)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> (ConfigGroup)invocationOnMock.getArguments()[0]);
        this.internalMigrationService = new InternalMigrationService((WorkspaceProjectService)this.projectService, (ConfigurationService)this.configService, (WorkspaceProjectMigrationService)this.projectMigrationService, this.repoService, this.system, this.spaceConfigStorageRegistry, this.backwardCompatibleUtil);
    }

    @Test
    public void testGetOrgUnitsByRepo() {
        String repo1Name = "repo1";
        String repo2Name = "repo2";
        String repo3Name = "repo3";
        String space1Name = "space1";
        String space2Name = "space2";
        int numberOfRepositories = 3;
        ArrayList<ConfigGroup> ouConfigs = new ArrayList<ConfigGroup>();
        List<String> space1Repos = Arrays.asList("repo1", "repo2");
        List<String> space2Repos = Arrays.asList("repo3");
        ConfigItem space1Config = new ConfigItem();
        space1Config.setName("repositories");
        space1Config.setValue(space1Repos);
        ConfigItem space2Config = new ConfigItem();
        space2Config.setName("repositories");
        space2Config.setValue(space2Repos);
        ConfigGroup space1 = new ConfigGroup();
        space1.setConfigItem(space1Config);
        space1.setName("space1");
        ConfigGroup space2 = new ConfigGroup();
        space2.setConfigItem(space2Config);
        space2.setName("space2");
        ouConfigs.add(space1);
        ouConfigs.add(space2);
        Map orgUnitsByRepo = this.internalMigrationService.getOrgUnitsByRepo(ouConfigs);
        Assert.assertEquals((long)3L, (long)orgUnitsByRepo.size());
        Assert.assertEquals((Object)"space1", orgUnitsByRepo.get("repo1"));
        Assert.assertEquals((Object)"space1", orgUnitsByRepo.get("repo2"));
        Assert.assertEquals((Object)"space2", orgUnitsByRepo.get("repo3"));
    }

    @Test
    public void testCreateSpaceDirs() {
        String firstOuName = "firstOrgUnit";
        String secondOuName = "secondOrgUnit";
        ConfigItem contributors = new ConfigItem();
        contributors.setName(SPACE_CONTRIBUTORS);
        contributors.setValue(new ArrayList());
        ConfigItem groups = new ConfigItem();
        groups.setName(SECURITY_GROUPS);
        groups.setValue(new ArrayList());
        ConfigGroup firstOuConfig = new ConfigGroup();
        firstOuConfig.setName("firstOrgUnit");
        firstOuConfig.addConfigItem(contributors);
        firstOuConfig.addConfigItem(groups);
        ConfigGroup secondOuConfig = new ConfigGroup();
        secondOuConfig.setName("secondOrgUnit");
        secondOuConfig.addConfigItem(contributors);
        secondOuConfig.addConfigItem(groups);
        ArrayList<ConfigGroup> orgUnitConfigs = new ArrayList<ConfigGroup>();
        orgUnitConfigs.add(firstOuConfig);
        orgUnitConfigs.add(secondOuConfig);
        Path mockPath = (Path)Mockito.mock(Path.class);
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockPath.toFile()).thenReturn((Object)mockFile);
        Mockito.when((Object)mockPath.resolve(ArgumentMatchers.anyString())).thenReturn((Object)mockPath);
        this.internalMigrationService.createSpaceDirs(mockPath, orgUnitConfigs);
        ((Path)Mockito.verify((Object)mockPath)).resolve("firstOrgUnit");
        ((Path)Mockito.verify((Object)mockPath)).resolve("secondOrgUnit");
        ((File)Mockito.verify((Object)mockFile, (VerificationMode)Mockito.times((int)2))).mkdir();
        ((SpaceConfigStorageRegistry)Mockito.verify((Object)this.spaceConfigStorageRegistry, (VerificationMode)Mockito.times((int)4))).get(ArgumentMatchers.anyString());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
    }
}

