/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.kie.workbench.common.project.cli.util.ConfigGroupToSpaceInfoConverter;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.kie.workbench.common.project.config.MigrationRepositoryServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectMigrationServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectServiceImpl;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InternalMigrationService.class, Files.class})
public class MigrateAllProjectsTest {
    private static final String SPACE_CONTRIBUTORS = "space-contributors";
    private static final String SECURITY_GROUPS = "security:groups";
    private static final String PROJECT_A = "projectA";
    private static final String PROJECT_B = "projectB";
    private static final String PROJECT_C = "projectC";
    private static final String PROJECT_D = "projectD";
    private static final String REPO_A = "repoA";
    private static final String REPO_B = "repoB";
    private static final String REPO_C = "repoC";
    private static final String SPACE_A = "spaceA";
    private static final String SPACE_B = "spaceB";
    private static final int NUMBER_OF_REPOS = 3;
    @Mock
    private MigrationWorkspaceProjectServiceImpl projectService;
    @Mock
    private MigrationConfigurationServiceImpl configService;
    @Mock
    private MigrationWorkspaceProjectMigrationServiceImpl projectMigrationService;
    @Mock
    private MigrationRepositoryServiceImpl repoService;
    @Mock
    private SystemAccess system;
    @Mock
    private ConfigGroupToSpaceInfoConverter configGroupToSpaceInfoConverter;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private BackwardCompatibleUtil backwardCompatibleUtil;
    @InjectMocks
    private InternalMigrationService service;

    @Before
    public void init() {
        Mockito.when((Object)this.configGroupToSpaceInfoConverter.toSpaceInfo((ConfigGroup)Mockito.any())).thenReturn((Object)((SpaceInfo)Mockito.mock(SpaceInfo.class)));
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(Mockito.anyString())).thenReturn((Object)((SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class)));
        Mockito.when((Object)this.backwardCompatibleUtil.compat((ConfigGroup)Mockito.any())).thenAnswer(invocationOnMock -> (ConfigGroup)invocationOnMock.getArguments()[0]);
    }

    public List<ConfigGroup> initConfigGroups() {
        ArrayList<ConfigGroup> spaceConfigs = new ArrayList<ConfigGroup>();
        List<String> spaceARepos = Collections.singletonList(REPO_A);
        List<String> spaceBRepos = Arrays.asList(REPO_B, REPO_C);
        ConfigItem spaceAConfig = new ConfigItem();
        spaceAConfig.setName("repositories");
        spaceAConfig.setValue(spaceARepos);
        ConfigItem spaceBConfig = new ConfigItem();
        spaceBConfig.setName("repositories");
        spaceBConfig.setValue(spaceBRepos);
        ConfigItem contributors = new ConfigItem();
        contributors.setName(SPACE_CONTRIBUTORS);
        contributors.setValue(new ArrayList());
        ConfigItem groups = new ConfigItem();
        groups.setName(SECURITY_GROUPS);
        groups.setValue(new ArrayList());
        ConfigGroup spaceA = new ConfigGroup();
        spaceA.setName(SPACE_A);
        spaceA.setConfigItem(spaceAConfig);
        spaceA.setConfigItem(contributors);
        spaceA.setConfigItem(groups);
        ConfigGroup spaceB = new ConfigGroup();
        spaceB.setName(SPACE_B);
        spaceB.setConfigItem(spaceBConfig);
        spaceB.setConfigItem(contributors);
        spaceB.setConfigItem(groups);
        spaceConfigs.add(spaceA);
        spaceConfigs.add(spaceB);
        return spaceConfigs;
    }

    private Repository mockRepo(String name) {
        Repository repo = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo.getAlias()).thenReturn((Object)name);
        return repo;
    }

    private WorkspaceProject mockProject(String name, Repository repository) {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Mockito.when((Object)project.getName()).thenReturn((Object)name);
        Mockito.when((Object)project.getRepository()).thenReturn((Object)repository);
        return project;
    }

    private List<WorkspaceProject> initWorkspaceProjects() {
        ArrayList<WorkspaceProject> workspaceProjects = new ArrayList<WorkspaceProject>();
        Repository repoA = this.mockRepo(REPO_A);
        Repository repoB = this.mockRepo(REPO_B);
        Repository repoC = this.mockRepo(REPO_C);
        WorkspaceProject projectA = this.mockProject(PROJECT_A, repoA);
        WorkspaceProject projectB = this.mockProject(PROJECT_B, repoA);
        WorkspaceProject projectC = this.mockProject(PROJECT_C, repoB);
        WorkspaceProject projectD = this.mockProject(PROJECT_D, repoC);
        workspaceProjects.add(projectA);
        workspaceProjects.add(projectB);
        workspaceProjects.add(projectC);
        workspaceProjects.add(projectD);
        return workspaceProjects;
    }

    @Test
    public void testMigrateAllProjects() throws Exception {
        List<ConfigGroup> spaceConfigs = this.initConfigGroups();
        List<WorkspaceProject> workspaceProjects = this.initWorkspaceProjects();
        PowerMockito.mockStatic(Files.class, (Class[])new Class[0]);
        Path niogitDir = (Path)Mockito.mock(Path.class);
        File niogitDirFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)Files.move((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), new CopyOption[0])).thenReturn((Object)niogitDir);
        Mockito.when((Object)this.projectService.getAllWorkspaceProjects()).thenReturn(workspaceProjects);
        Mockito.when((Object)this.system.out()).thenReturn((Object)System.out);
        Mockito.when((Object)this.configService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT)).thenReturn(spaceConfigs);
        Mockito.when((Object)this.configService.getConfiguration(ConfigType.REPOSITORY)).thenReturn(spaceConfigs);
        Mockito.when((Object)niogitDir.toFile()).thenReturn((Object)niogitDirFile);
        Mockito.when((Object)niogitDir.resolve(Mockito.anyString())).thenReturn((Object)niogitDir);
        this.service.migrateAllProjects(niogitDir);
        ((MigrationWorkspaceProjectMigrationServiceImpl)Mockito.verify((Object)this.projectMigrationService, (VerificationMode)Mockito.times((int)workspaceProjects.size()))).migrate((WorkspaceProject)Mockito.any(WorkspaceProject.class));
        ((MigrationRepositoryServiceImpl)Mockito.verify((Object)this.repoService, (VerificationMode)Mockito.times((int)3))).deleteRepository((Repository)Mockito.any());
    }
}

