/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.config;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.DefaultPasswordServiceImpl;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.config.PasswordService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.project.config.MigrationConfigurationFactoryImpl;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MigrationConfigurationServiceImplTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock
    private Repository systemRepository;
    @Mock
    private User identity;
    @Mock
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> spaceChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> changedEvent;
    private ConfigGroupMarshaller marshaller;
    private IOService ioService;
    private ConfigurationFactory configurationFactory;
    private ConfigurationService configurationService;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        Mockito.when((Object)this.systemRepository.getUri()).thenReturn((Object)"git://amend-repo-test");
        this.marshaller = new ConfigGroupMarshaller();
        this.configurationFactory = new MigrationConfigurationFactoryImpl((PasswordService)new DefaultPasswordServiceImpl());
        this.ioService = this.mockIoService();
        this.configurationService = new MigrationConfigurationServiceImpl(this.systemRepository, this.marshaller, this.identity, this.ioService, this.repoChangedEvent, this.spaceChangedEvent, this.changedEvent, fileSystemTestingUtils.getFileSystem());
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void addAndGetConfigurationWithoutNamespaceTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.SPACE, "space1", "space1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global2", "global2-description"));
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)2L, (long)globalConfigGroups.size());
        Assert.assertEquals((Object)"global1", (Object)((ConfigGroup)globalConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"global2", (Object)((ConfigGroup)globalConfigGroups.get(1)).getName());
        List spaceConfigGroups = this.configurationService.getConfiguration(ConfigType.SPACE);
        Assert.assertEquals((long)1L, (long)spaceConfigGroups.size());
        Assert.assertEquals((Object)"space1", (Object)((ConfigGroup)spaceConfigGroups.get(0)).getName());
    }

    @Test
    public void addAndGetConfigurationWithNamespaceTest() {
        ConfigGroup configGroup1 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo1", "repo1-description");
        configGroup1.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace1"));
        this.configurationService.addConfiguration(configGroup1);
        ConfigGroup configGroup2 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo2", "repo2-description");
        configGroup2.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace1"));
        this.configurationService.addConfiguration(configGroup2);
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        ConfigGroup configGroup3 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace2", "repo3", "repo3-description");
        configGroup3.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace2"));
        this.configurationService.addConfiguration(configGroup3);
        List repositoryNamespace1ConfigGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace1");
        Assert.assertEquals((long)2L, (long)repositoryNamespace1ConfigGroups.size());
        Assert.assertEquals((Object)"repo1", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"repo2", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(1)).getName());
        List repositoryNamespace2ConfigGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace2");
        Assert.assertEquals((long)1L, (long)repositoryNamespace2ConfigGroups.size());
        Assert.assertEquals((Object)"repo3", (Object)((ConfigGroup)repositoryNamespace2ConfigGroups.get(0)).getName());
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)1L, (long)globalConfigGroups.size());
        Assert.assertEquals((Object)"global1", (Object)((ConfigGroup)globalConfigGroups.get(0)).getName());
    }

    @Test
    public void addAndGetConfigurationByNamespaceTest() {
        ConfigGroup configGroup1 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo1", "repo1-description");
        configGroup1.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace1"));
        this.configurationService.addConfiguration(configGroup1);
        ConfigGroup configGroup2 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo2", "repo2-description");
        configGroup2.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace1"));
        this.configurationService.addConfiguration(configGroup2);
        ConfigGroup configGroup3 = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace2", "repo3", "repo3-description");
        configGroup3.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace2"));
        this.configurationService.addConfiguration(configGroup3);
        Map configGroupsByNamespace = this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY);
        Assert.assertEquals((long)2L, (long)configGroupsByNamespace.size());
        List repositoryNamespace1ConfigGroups = (List)configGroupsByNamespace.get("namespace1");
        Assert.assertEquals((long)2L, (long)repositoryNamespace1ConfigGroups.size());
        Assert.assertEquals((Object)"repo1", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"repo2", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(1)).getName());
        List repositoryNamespace2ConfigGroups = (List)configGroupsByNamespace.get("namespace2");
        Assert.assertEquals((long)1L, (long)repositoryNamespace2ConfigGroups.size());
        Assert.assertEquals((Object)"repo3", (Object)((ConfigGroup)repositoryNamespace2ConfigGroups.get(0)).getName());
    }

    @Test
    public void updateConfigurationWithoutNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "config", "description");
        this.configurationService.addConfiguration(config);
        config.setDescription("new-description");
        this.configurationService.updateConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)1L, (long)configGroups.size());
        Assert.assertEquals((Object)"config", (Object)((ConfigGroup)configGroups.get(0)).getName());
        Assert.assertEquals((Object)"new-description", (Object)((ConfigGroup)configGroups.get(0)).getDescription());
    }

    @Test
    public void updateConfigurationWithNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace", "config", "description");
        config.addConfigItem(this.configurationFactory.newConfigItem("space", "namespace"));
        this.configurationService.addConfiguration(config);
        config.setDescription("new-description");
        this.configurationService.updateConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace");
        Assert.assertEquals((long)1L, (long)configGroups.size());
        Assert.assertEquals((Object)"config", (Object)((ConfigGroup)configGroups.get(0)).getName());
        Assert.assertEquals((Object)"new-description", (Object)((ConfigGroup)configGroups.get(0)).getDescription());
    }

    @Test
    public void removeConfigurationWithoutNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "config", "description");
        this.configurationService.removeConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)0L, (long)configGroups.size());
    }

    @Test
    public void removeConfigurationWithNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace", "config", "description");
        this.configurationService.addConfiguration(config);
        this.configurationService.removeConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace");
        Assert.assertEquals((long)0L, (long)configGroups.size());
    }

    private IOService mockIoService() {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)ArgumentMatchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)fileSystemTestingUtils.getFileSystem()).when((Object)ioService)).newFileSystem((URI)ArgumentMatchers.any(URI.class), ArgumentMatchers.anyMap());
        return ioService;
    }
}

