/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.kie.workbench.common.project.config.MigrationRepositoryServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectMigrationServiceImpl;
import org.kie.workbench.common.project.config.MigrationWorkspaceProjectServiceImpl;

@ApplicationScoped
public class InternalMigrationService {
    @Inject
    private MigrationWorkspaceProjectServiceImpl projectService;
    @Inject
    private MigrationConfigurationServiceImpl configService;
    @Inject
    private MigrationWorkspaceProjectMigrationServiceImpl projectMigrationService;
    @Inject
    private MigrationRepositoryServiceImpl repoService;
    @Inject
    private SystemAccess system;

    public void migrateAllProjects(Path niogitDir) {
        List<ConfigGroup> orgUnitConfigs = this.configService.getConfiguration(ConfigType.ORGANIZATIONAL_UNIT);
        List<ConfigGroup> repoConfigs = this.configService.getConfiguration(ConfigType.REPOSITORY);
        Map<String, String> orgUnitByRepo = InternalMigrationService.getOrgUnitsByRepo(orgUnitConfigs);
        if (repoConfigs.isEmpty()) {
            this.printNoReposMessage();
        } else {
            this.prepareRepositoriesForMigration(niogitDir, orgUnitConfigs, repoConfigs, orgUnitByRepo);
            this.migrateProjectsToIndividualRepos();
        }
    }

    private void prepareRepositoriesForMigration(Path niogitDir, List<ConfigGroup> orgUnitConfigs, List<ConfigGroup> repoConfigs, Map<String, String> orgUnitByRepo) {
        this.printFoundRepositoriesMessage(repoConfigs);
        this.addSpacesToRepoConfigs(orgUnitByRepo, repoConfigs);
        this.migrateReposToSpaces(niogitDir, orgUnitConfigs, orgUnitByRepo);
    }

    private void printFoundRepositoriesMessage(List<ConfigGroup> repoConfigs) {
        this.system.out().printf("Found %s user %s:\n", repoConfigs.size(), repoConfigs.size() > 1 ? "repositories" : "repository");
        repoConfigs.forEach(group -> this.system.out().printf("\t%s\n", group.getName()));
    }

    private void printNoReposMessage() {
        this.system.out().println("No user repositories found.");
    }

    private void migrateProjectsToIndividualRepos() {
        Collection allProjects = this.projectService.getAllWorkspaceProjects();
        this.printFoundProjectsMessage(allProjects);
        LinkedHashSet cleanup = new LinkedHashSet();
        allProjects.forEach(proj -> {
            this.system.out().printf("Migrating [%s]...\n", proj.getName());
            cleanup.add(proj.getRepository());
            this.projectMigrationService.migrate((WorkspaceProject)proj);
        });
        cleanup.forEach(repo -> {
            this.system.out().printf("Removing migrated repository [%s]...\n", repo.getAlias());
            this.repoService.removeRepository(repo.getSpace(), repo.getAlias());
        });
        this.system.out().println("Finished project migration.");
    }

    private void printFoundProjectsMessage(Collection<WorkspaceProject> allProjects) {
        this.system.out().printf("Found %s %s:\n", allProjects.size(), allProjects.size() > 1 ? "projects" : "project");
        allProjects.forEach(proj -> this.system.out().printf("\t%s\n", proj.getName()));
    }

    private void migrateReposToSpaces(Path niogitDir, List<ConfigGroup> orgUnitConfigs, Map<String, String> orgUnitByRepo) {
        InternalMigrationService.createSpaceDirs(niogitDir, orgUnitConfigs);
        this.moveRepos(niogitDir, orgUnitByRepo);
    }

    private void moveRepos(Path niogitDir, Map<String, String> orgUnitByRepo) {
        this.system.out().println("Moving repositories into spaces...");
        orgUnitByRepo.forEach((repo, ou) -> {
            String repoFolderName = repo + ".git";
            Path oldRepo = niogitDir.resolve(repoFolderName);
            Path newRepo = niogitDir.resolve((String)ou).resolve(repoFolderName);
            try {
                this.system.out().printf("Moving repo [%s] into space [%s]...\n", repo, ou);
                Files.move(oldRepo, newRepo, new CopyOption[0]);
            }
            catch (IOException e) {
                this.system.err().printf("Unable to move [%s].\n", oldRepo);
                e.printStackTrace(this.system.err());
            }
        });
        this.system.out().println("Finished moving repositories into space.");
    }

    static void createSpaceDirs(Path niogitDir, List<ConfigGroup> orgUnitConfigs) {
        orgUnitConfigs.stream().map(group -> group.getName()).forEach(ou -> {
            Path ouSpace = niogitDir.resolve((String)ou);
            ouSpace.toFile().mkdir();
        });
    }

    private void addSpacesToRepoConfigs(Map<String, String> orgUnitByRepo, List<ConfigGroup> repoConfigs) {
        this.system.out().println("Updating repository configurations with spaces...");
        this.configService.startBatch();
        repoConfigs.forEach(group -> {
            String space = (String)orgUnitByRepo.get(group.getName());
            if (space != null) {
                this.system.out().printf("Configuring repo [%s] in space [%s]...\n", group.getName(), space);
                ConfigItem item = new ConfigItem();
                item.setName("space");
                item.setValue((Object)space);
                group.setConfigItem(item);
                this.configService.updateConfiguration((ConfigGroup)group);
            }
        });
        this.configService.endBatch();
        this.system.out().println("Finished updating repository configurations.");
    }

    static Map<String, String> getOrgUnitsByRepo(List<ConfigGroup> orgUnitConfigs) {
        LinkedHashMap<String, String> orgUnitByRepo = new LinkedHashMap<String, String>();
        orgUnitConfigs.stream().forEach(group -> {
            ConfigItem repos = group.getConfigItem("repositories");
            Optional.ofNullable(repos).map(r -> (List)r.getValue()).ifPresent(r -> r.forEach(repo -> orgUnitByRepo.put((String)repo, group.getName())));
        });
        return orgUnitByRepo;
    }
}

