/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.factory;

import java.util.function.Function;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public abstract class AbstractDMNDiagramFactory<M extends Metadata, D extends Diagram<Graph, M>>
extends BindableDiagramFactory<M, D> {
    private static final Class<DMNDiagram> DIAGRAM_TYPE = DMNDiagram.class;
    private Function<Graph, Node<Definition<DMNDiagram>, ?>> diagramProvider = graph -> GraphUtils.getFirstNode((Graph)graph, DIAGRAM_TYPE);

    protected abstract D doBuild(String var1, M var2, Graph<DefinitionSet, ?> var3);

    public D build(String name, M metadata, Graph<DefinitionSet, ?> graph) {
        D diagram = this.doBuild(name, metadata, graph);
        Node<Definition<DMNDiagram>, ?> diagramNode = this.diagramProvider.apply(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A DMNDiagram is expected to be present on DMN Diagram graphs.");
        }
        this.updateProperties(diagramNode, metadata);
        this.updateDefaultNameSpaces(diagramNode);
        this.updateName(diagramNode, name);
        return diagram;
    }

    private void updateProperties(Node<Definition<DMNDiagram>, ?> diagramNode, M metadata) {
        metadata.setCanvasRootUUID(diagramNode.getUUID());
    }

    private void updateDefaultNameSpaces(Node<Definition<DMNDiagram>, ?> diagramNode) {
        DMNDiagram dmnDiagram = (DMNDiagram)((Definition)diagramNode.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        Stream.of(DMNModelInstrumentedBase.Namespace.values()).filter(namespace -> !dmnDefinitions.getNsContext().containsValue(namespace.getUri())).forEach(namespace -> dmnDefinitions.getNsContext().put(namespace.getPrefix(), namespace.getUri()));
    }

    private void updateName(Node<Definition<DMNDiagram>, ?> diagramNode, String name) {
        DMNDiagram dmnDiagram = (DMNDiagram)((Definition)diagramNode.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        dmnDefinitions.getName().setValue(name);
    }
}

