/*
* Copyright 2017 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.kie.workbench.common.dmn.api.definition.v1_1.formBuilder.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;

import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.building.FormGenerationResourcesProvider;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FieldElement;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FormElement;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;

@Generated("org.kie.workbench.common.forms.adf.processors.FormDefinitionsProcessor")
@ApplicationScoped
public class ModuleFormGenerationResourcesProvider implements FormGenerationResourcesProvider {

    private Map<String, FormDefinitionSettings> definitionSettings = new HashMap<>();

    private Map<String, FieldStatusModifier> fieldStatusModifiers = new HashMap<>();

    private Map<String, String> fieldStatusModifiersReferences = new HashMap<>();

    public ModuleFormGenerationResourcesProvider() {
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram", new org_kie_workbench_common_dmn_api_definition_v1_1_DMNDiagramFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", new org_kie_workbench_common_dmn_api_property_dimensions_RectangleDimensionsSetFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem", new org_kie_workbench_common_dmn_api_definition_v1_1_InformationItemFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.NOPDomainObject", new org_kie_workbench_common_dmn_api_definition_NOPDomainObjectFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues", new org_kie_workbench_common_dmn_api_definition_v1_1_ImportedValuesFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests", new org_kie_workbench_common_dmn_api_definition_v1_1_InputClauseUnaryTestsFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", new org_kie_workbench_common_dmn_api_property_background_BackgroundSetFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InputData", new org_kie_workbench_common_dmn_api_definition_v1_1_InputDataFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause", new org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.property.font.FontSet", new org_kie_workbench_common_dmn_api_property_font_FontSetFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClause", new org_kie_workbench_common_dmn_api_definition_v1_1_InputClauseFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression", new org_kie_workbench_common_dmn_api_definition_v1_1_LiteralExpressionFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression", new org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseLiteralExpressionFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel", new org_kie_workbench_common_dmn_api_definition_v1_1_BusinessKnowledgeModelFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Decision", new org_kie_workbench_common_dmn_api_definition_v1_1_DecisionFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions", new org_kie_workbench_common_dmn_api_definition_v1_1_DefinitionsFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement", new org_kie_workbench_common_dmn_api_definition_v1_1_InformationRequirementFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests", new org_kie_workbench_common_dmn_api_definition_v1_1_UnaryTestsFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource", new org_kie_workbench_common_dmn_api_definition_v1_1_KnowledgeSourceFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation", new org_kie_workbench_common_dmn_api_definition_v1_1_TextAnnotationFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement", new org_kie_workbench_common_dmn_api_definition_v1_1_AuthorityRequirementFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Association", new org_kie_workbench_common_dmn_api_definition_v1_1_AssociationFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement", new org_kie_workbench_common_dmn_api_definition_v1_1_KnowledgeRequirementFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests", new org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseUnaryTestsFormBuilder().getSettings() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_font_FontColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_font_FontColour_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_font_FontFamily_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_font_FontFamily_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_background_BgColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_background_BgColour_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_font_FontBorderSize_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_font_FontBorderSize_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_background_BorderSize_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_background_BorderSize_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_font_FontSize_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_font_FontSize_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_background_BorderColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_background_BorderColour_FieldStatusModifier() );
        fieldStatusModifiers.put( "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier() );
    }

    @Override
    public Map<String, FormDefinitionSettings> getDefinitionSettings() {
        return definitionSettings;
    }

    @Override
    public Map<String, FieldStatusModifier> getFieldModifiers() {
        return fieldStatusModifiers;
    }

    @Override
    public Map<String, String> getFieldModifierReferences() {
        return fieldStatusModifiersReferences;
    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_DMNDiagramFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_definitions() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_definitions() {
            FieldElement field = new FieldElement( "definitions", "definitions", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.Definitions.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_property_dimensions_RectangleDimensionsSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_width() );
            elements.add( getFormElement_height() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_width() {
            FieldElement field = new FieldElement( "width", "width.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Double", false) );
            field.setPreferredType( org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.Width.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.Width.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "step", "25.0" );
            field.getParams().put( "min", "50.0" );
            field.getParams().put( "max", "200.0" );
            field.getParams().put( "precision", "0.0" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.width", "org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_height() {
            FieldElement field = new FieldElement( "height", "height.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Double", false) );
            field.setPreferredType( org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.Height.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.Height.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "step", "25.0" );
            field.getParams().put( "min", "50.0" );
            field.getParams().put( "max", "200.0" );
            field.getParams().put( "precision", "0.0" );
            field.getLayoutSettings().setAfterElement( "width" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.height", "org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_InformationItemFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_typeRefHolder() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_typeRefHolder() {
            FieldElement field = new FieldElement( "typeRefHolder", "typeRefHolder.value", new TypeInfoImpl( TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.QName", false) );
            field.setPreferredType( org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.typeRefHolder", "org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_NOPDomainObjectFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.NOPDomainObject" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.NOPDomainObject" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll( elements );
            return settings;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_ImportedValuesFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_InputClauseUnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_text() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement( "text", "text.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests.text" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests.");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "text" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_property_background_BackgroundSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_bgColour() );
            elements.add( getFormElement_borderColour() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_bgColour() {
            FieldElement field = new FieldElement( "bgColour", "bgColour.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BgColour.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BgColour.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.bgColour", "org_kie_workbench_common_dmn_api_property_background_BgColour_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_borderColour() {
            FieldElement field = new FieldElement( "borderColour", "borderColour.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BorderColour.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BorderColour.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "bgColour" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.borderColour", "org_kie_workbench_common_dmn_api_property_background_BorderColour_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_InputDataFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputData" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputData" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_variable() );
            elements.add( getFormElement_backgroundSet() );
            elements.add( getFormElement_fontSet() );
            elements.add( getFormElement_dimensionsSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement( "variable", "variable", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_backgroundSet() {
            FieldElement field = new FieldElement( "backgroundSet", "backgroundSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BackgroundSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "variable" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_fontSet() {
            FieldElement field = new FieldElement( "fontSet", "fontSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.font.FontSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "backgroundSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dimensionsSet() {
            FieldElement field = new FieldElement( "dimensionsSet", "dimensionsSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "fontSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_outputValues() );
            elements.add( getFormElement_defaultOutputEntry() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_outputValues() {
            FieldElement field = new FieldElement( "outputValues", "outputValues", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.outputValues" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_defaultOutputEntry() {
            FieldElement field = new FieldElement( "defaultOutputEntry", "defaultOutputEntry", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.defaultOutputEntry" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "outputValues" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_property_font_FontSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.property.font.FontSet" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.property.font.FontSet" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_fontFamily() );
            elements.add( getFormElement_fontColour() );
            elements.add( getFormElement_fontSize() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_fontFamily() {
            FieldElement field = new FieldElement( "fontFamily", "fontFamily.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontFamily.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontFamily.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.font.FontSet.fontFamily", "org_kie_workbench_common_dmn_api_property_font_FontFamily_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_fontColour() {
            FieldElement field = new FieldElement( "fontColour", "fontColour.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontColour.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontColour.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "fontFamily" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.font.FontSet.fontColour", "org_kie_workbench_common_dmn_api_property_font_FontColour_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_fontSize() {
            FieldElement field = new FieldElement( "fontSize", "fontSize.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Double", false) );
            field.setPreferredType( org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontSize.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontSize.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "step", "1.0" );
            field.getParams().put( "min", "8.0" );
            field.getParams().put( "max", "24.0" );
            field.getLayoutSettings().setAfterElement( "fontColour" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.property.font.FontSet.fontSize", "org_kie_workbench_common_dmn_api_property_font_FontSize_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_InputClauseFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClause" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClause" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_inputValues() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_inputValues() {
            FieldElement field = new FieldElement( "inputValues", "inputValues", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.inputValues" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseUnaryTests.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_LiteralExpressionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseLiteralExpressionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_text() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement( "text", "text.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.text" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_BusinessKnowledgeModelFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_variable() );
            elements.add( getFormElement_backgroundSet() );
            elements.add( getFormElement_fontSet() );
            elements.add( getFormElement_dimensionsSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement( "variable", "variable", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_backgroundSet() {
            FieldElement field = new FieldElement( "backgroundSet", "backgroundSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BackgroundSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "variable" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_fontSet() {
            FieldElement field = new FieldElement( "fontSet", "fontSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.font.FontSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "backgroundSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dimensionsSet() {
            FieldElement field = new FieldElement( "dimensionsSet", "dimensionsSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "fontSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_DecisionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Decision" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Decision" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_question() );
            elements.add( getFormElement_allowedAnswers() );
            elements.add( getFormElement_variable() );
            elements.add( getFormElement_backgroundSet() );
            elements.add( getFormElement_fontSet() );
            elements.add( getFormElement_dimensionsSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_question() {
            FieldElement field = new FieldElement( "question", "question.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Question.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Question.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Decision.question", "org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_allowedAnswers() {
            FieldElement field = new FieldElement( "allowedAnswers", "allowedAnswers.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "question" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Decision.allowedAnswers", "org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement( "variable", "variable", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "allowedAnswers" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_backgroundSet() {
            FieldElement field = new FieldElement( "backgroundSet", "backgroundSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BackgroundSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_fontSet() {
            FieldElement field = new FieldElement( "fontSet", "fontSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.font.FontSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dimensionsSet() {
            FieldElement field = new FieldElement( "dimensionsSet", "dimensionsSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_DefinitionsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_expressionLanguage() );
            elements.add( getFormElement_namespace() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_namespace() {
            FieldElement field = new FieldElement( "namespace", "namespace.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "namespace" );
            field.setHelpMessageKey("");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "expressionLanguage" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.Definitions.namespace", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_InformationRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll( elements );
            return settings;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_UnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_KnowledgeSourceFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_name() );
            elements.add( getFormElement_type() );
            elements.add( getFormElement_locationURI() );
            elements.add( getFormElement_backgroundSet() );
            elements.add( getFormElement_fontSet() );
            elements.add( getFormElement_dimensionsSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_name() {
            FieldElement field = new FieldElement( "name", "name.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Name.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Name.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement.name", "org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_type() {
            FieldElement field = new FieldElement( "type", "type.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "name" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.type", "org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_locationURI() {
            FieldElement field = new FieldElement( "locationURI", "locationURI.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.LocationURI.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.LocationURI.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "type" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.locationURI", "org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_backgroundSet() {
            FieldElement field = new FieldElement( "backgroundSet", "backgroundSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.background.BackgroundSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.background.BackgroundSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "locationURI" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_fontSet() {
            FieldElement field = new FieldElement( "fontSet", "fontSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.font.FontSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.font.FontSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.font.FontSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "backgroundSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dimensionsSet() {
            FieldElement field = new FieldElement( "dimensionsSet", "dimensionsSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "fontSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_TextAnnotationFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_text() );
            elements.add( getFormElement_textFormat() );
            elements.add( getFormElement_backgroundSet() );
            elements.add( getFormElement_fontSet() );
            elements.add( getFormElement_dimensionsSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement( "text", "text.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.text" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_textFormat() {
            FieldElement field = new FieldElement( "textFormat", "textFormat.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.TextFormat.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.TextFormat.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "text" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.textFormat", "org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_backgroundSet() {
            FieldElement field = new FieldElement( "backgroundSet", "backgroundSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.background.BackgroundSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.background.BackgroundSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.background.BackgroundSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "variable" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_fontSet() {
            FieldElement field = new FieldElement( "fontSet", "fontSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.font.FontSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.font.FontSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.font.FontSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "backgroundSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dimensionsSet() {
            FieldElement field = new FieldElement( "dimensionsSet", "dimensionsSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "fontSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_AuthorityRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll( elements );
            return settings;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_AssociationFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Association" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.Association" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_KnowledgeRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll( elements );
            return settings;
        }

    }

    class org_kie_workbench_common_dmn_api_definition_v1_1_OutputClauseUnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_id() );
            elements.add( getFormElement_description() );
            elements.add( getFormElement_text() );
            elements.add( getFormElement_expressionLanguage() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement( "id", "id.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Id.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement( "description", "description.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.Description.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "id" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement( "text", "text.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests.text" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests.");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "description" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement( "expressionLanguage", "expressionLanguage.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label" );
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "text" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseUnaryTests.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_font_FontColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.font.FontColour> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.font.FontColour model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dimensions.Height> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dimensions.Height model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_font_FontFamily_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.font.FontFamily> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.font.FontFamily model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Description> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Description model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_background_BgColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.background.BgColour> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.background.BgColour model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.LocationURI> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.LocationURI model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_font_FontBorderSize_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.font.FontBorderSize> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.font.FontBorderSize model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_background_BorderSize_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.background.BorderSize> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.background.BorderSize model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Name_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Name> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Name model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Question> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Question model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Text> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Text model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.TextFormat> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.TextFormat model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_font_FontSize_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.font.FontSize> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.font.FontSize model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dimensions.Width> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dimensions.Width model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Id> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Id model ) {
            if ( model != null ) {
                field.setReadOnly( Boolean.TRUE.equals( model.isReadOnly() ) );
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.QNameHolder> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.QNameHolder model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_background_BorderColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.background.BorderColour> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.background.BorderColour model ) {
            if ( model != null ) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage model ) {
            if ( model != null ) {
            }
        }
    }

}
