/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.factory;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.factory.DMNDiagramFactoryImpl;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDiagramFactoryImplTest {
    private static final String NAME = "name";
    private static final String EXISTING_NAME = "existing-name";
    @Mock
    private Metadata metadata;
    @Mock
    private Bounds bounds;
    private GraphImpl<DefinitionSet> graph;
    private DMNDiagramFactoryImpl factory;

    @Before
    public void setup() {
        this.factory = new DMNDiagramFactoryImpl();
        this.graph = new GraphImpl(UUID.uuid(), (GraphNodeStore)new GraphNodeStoreImpl());
        this.graph.addNode(this.newNode(new DMNDiagram()));
    }

    private Node<View, Edge> newNode(Object definition) {
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl content = new ViewImpl(definition, this.bounds);
        node.setContent((Object)content);
        return node;
    }

    @Test
    public void testDefaultNameSpaces() {
        Diagram diagram = this.factory.build(NAME, this.metadata, this.graph);
        Node root = (Node)diagram.getGraph().nodes().iterator().next();
        DMNDiagram dmnDiagram = (DMNDiagram)((View)root.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        Map dmnDefaultNameSpaces = dmnDefinitions.getNsContext();
        Assert.assertTrue((boolean)dmnDefaultNameSpaces.containsKey(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix()));
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getUri(), dmnDefaultNameSpaces.get(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix()));
        Assert.assertTrue((boolean)dmnDefaultNameSpaces.containsKey(DMNModelInstrumentedBase.Namespace.DMN.getPrefix()));
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.DMN.getUri(), dmnDefaultNameSpaces.get(DMNModelInstrumentedBase.Namespace.DMN.getPrefix()));
        Assert.assertTrue((boolean)dmnDefaultNameSpaces.containsKey(DMNModelInstrumentedBase.Namespace.KIE.getPrefix()));
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.KIE.getUri(), dmnDefaultNameSpaces.get(DMNModelInstrumentedBase.Namespace.KIE.getPrefix()));
        Assert.assertTrue((boolean)dmnDefaultNameSpaces.containsKey(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix()));
        Assert.assertEquals((Object)dmnDefinitions.getNamespace().getValue(), dmnDefaultNameSpaces.get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix()));
    }

    @Test
    public void testModelName() {
        Diagram diagram = this.factory.build(NAME, this.metadata, this.graph);
        Node root = (Node)diagram.getGraph().nodes().iterator().next();
        DMNDiagram dmnDiagram = (DMNDiagram)((View)root.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        Assert.assertEquals((Object)NAME, (Object)dmnDefinitions.getName().getValue());
    }

    @Test
    public void testModelNameWithNonEmptyExistingName() {
        Node existingRoot = (Node)this.graph.nodes().iterator().next();
        DMNDiagram existingDMNDiagram = (DMNDiagram)((View)existingRoot.getContent()).getDefinition();
        Definitions existingDMNDefinitions = existingDMNDiagram.getDefinitions();
        existingDMNDefinitions.getName().setValue(EXISTING_NAME);
        Diagram newDiagram = this.factory.build(NAME, this.metadata, this.graph);
        Node newRoot = (Node)newDiagram.getGraph().nodes().iterator().next();
        DMNDiagram newDMNDiagram = (DMNDiagram)((View)newRoot.getContent()).getDefinition();
        Definitions newDMNDefinitions = newDMNDiagram.getDefinitions();
        Assert.assertEquals((Object)EXISTING_NAME, (Object)newDMNDefinitions.getName().getValue());
    }
}

