/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.factory;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.factory.DMNGraphFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.impl.AbstractGraphFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.EmptyRulesCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@ApplicationScoped
public class DMNGraphFactoryImpl
extends AbstractGraphFactory
implements DMNGraphFactory {
    private static final Class<DMNDiagram> DIAGRAM_TYPE = DMNDiagram.class;
    private final DefinitionManager definitionManager;
    private final GraphCommandManager graphCommandManager;
    private final GraphCommandFactory graphCommandFactory;
    private final FactoryManager factoryManager;
    private final GraphIndexBuilder<?> indexBuilder;
    private final RuleManager ruleManager;

    protected DMNGraphFactoryImpl() {
        this(null, null, null, null, null, null);
    }

    protected double getWidth() {
        return 1400.0;
    }

    protected double getHeight() {
        return 700.0;
    }

    @Inject
    public DMNGraphFactoryImpl(DefinitionManager definitionManager, FactoryManager factoryManager, GraphCommandManager graphCommandManager, GraphCommandFactory graphCommandFactory, GraphIndexBuilder<?> indexBuilder, RuleManager ruleManager) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.graphCommandManager = graphCommandManager;
        this.graphCommandFactory = graphCommandFactory;
        this.indexBuilder = indexBuilder;
        this.ruleManager = ruleManager;
    }

    public Class<? extends ElementFactory> getFactoryType() {
        return DMNGraphFactory.class;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definitionSetId) {
        Graph graph = super.build(uuid, definitionSetId);
        List<Command> commands = this.buildInitialisationCommands();
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commands.forEach(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
        this.graphCommandManager.execute((Object)this.createGraphContext(graph), (Command)commandBuilder.build());
        return graph;
    }

    public boolean accepts(String source) {
        return true;
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    protected List<Command> buildInitialisationCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Node diagramNode = (Node)this.factoryManager.newElement(UUID.uuid(), DIAGRAM_TYPE);
        commands.add((Command)this.graphCommandFactory.addNode(diagramNode));
        return commands;
    }

    protected GraphCommandExecutionContext createGraphContext(Graph graph) {
        Index index = this.indexBuilder.build(graph);
        return new EmptyRulesCommandExecutionContext(this.definitionManager, this.factoryManager, this.ruleManager, index);
    }
}

