/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphWalker;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.rule.violations.RuleViolationImpl;

@ApplicationScoped
public class AcyclicDirectedGraphRule
extends RuleExtensionHandler<AcyclicDirectedGraphRule, GraphConnectionContext> {
    static final String ERROR_MESSAGE = "Connection would violate Directed Acrylic Graph consistency.";

    public Class<AcyclicDirectedGraphRule> getExtensionType() {
        return AcyclicDirectedGraphRule.class;
    }

    public Class<GraphConnectionContext> getContextType() {
        return GraphConnectionContext.class;
    }

    public boolean accepts(RuleExtension rule, GraphConnectionContext context) {
        Object o = ((View)context.getConnector().getContent()).getDefinition();
        Class type = rule.getTypeArguments()[0];
        return o.getClass().equals(type);
    }

    public RuleViolations evaluate(RuleExtension rule, GraphConnectionContext context) {
        Graph graph = context.getGraph();
        Optional oSource = context.getSource();
        Optional oTarget = context.getTarget();
        Edge oConnector = context.getConnector();
        DefaultRuleViolations result = new DefaultRuleViolations();
        if (!oSource.isPresent() || !oTarget.isPresent()) {
            return result;
        }
        Node source = (Node)oSource.get();
        Node target = (Node)oTarget.get();
        Edge connector = oConnector;
        try {
            TreeWalkTraverseProcessor walker = this.getTreeWalker(source, target, connector);
            walker.traverse((Object)graph, (Object)new TreeTraverseCallback<Graph, Node, Edge>(){
                final Set<Node> inProgress = new HashSet<Node>();

                public void startGraphTraversal(Graph graph) {
                }

                public boolean startNodeTraversal(Node node) {
                    if (this.inProgress.contains(node)) {
                        throw new DirectedAcrylicGraphViolationException();
                    }
                    this.inProgress.add(node);
                    return true;
                }

                public boolean startEdgeTraversal(Edge edge) {
                    return true;
                }

                public void endNodeTraversal(Node node) {
                    this.inProgress.remove(node);
                }

                public void endEdgeTraversal(Edge edge) {
                }

                public void endGraphTraversal() {
                }
            });
        }
        catch (DirectedAcrylicGraphViolationException e) {
            result.addViolation((RuleViolation)new RuleViolationImpl(ERROR_MESSAGE));
        }
        return result;
    }

    protected TreeWalkTraverseProcessor getTreeWalker(Node<?, Edge> source, Node<?, Edge> target, Edge<?, Node> connector) {
        return new AcyclicDirectedGraphWalker(source, target, connector);
    }

    private static class DirectedAcrylicGraphViolationException
    extends RuntimeException {
        private DirectedAcrylicGraphViolationException() {
        }
    }
}

