/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.factory;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import java.util.LinkedHashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.factory.ModelFactoryGenerator")
@ApplicationScoped
public class DMNDefinitionSetModelFactoryImpl extends org.kie.workbench.common.stunner.core.factory.definition.AbstractTypeDefinitionFactory<Object> {

    private static final Set<Class<?>> SUPPORTED_DEF_CLASSES = new LinkedHashSet<Class<?>>() {{

            add( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class );
            add( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class );
            add( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class );

    }};

    public DMNDefinitionSetModelFactoryImpl() {
    }

    @Override
    public Set<Class<?>> getAcceptedClasses() {
        return SUPPORTED_DEF_CLASSES;
    }

    @Override
    public Object build( final Class<?> clazz ) {


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.AuthorityRequirementBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InputData();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource();

            }


            if ( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.NOPDomainObject();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.Association();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InputClause();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.Decision();

            }


            if ( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.DMNDefinitionSet.DMNDefinitionSetBuilder().build();

            }


        throw new RuntimeException( "This factory [" + this.getClass().getName() + "] " +
            "should provide a definition for [" + clazz + "]" );
    }

}
