/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class ContextTest {
    private Context context;

    @Before
    public void setup() {
        this.context = (Context)Mockito.spy((Object)new Context());
    }

    @Test
    public void testGetHasTypeRefs() {
        ContextEntry contextEntry1 = (ContextEntry)Mockito.mock(ContextEntry.class);
        ContextEntry contextEntry2 = (ContextEntry)Mockito.mock(ContextEntry.class);
        List<ContextEntry> contextEntry = Arrays.asList(contextEntry1, contextEntry2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Context)Mockito.doReturn(contextEntry).when((Object)this.context)).getContextEntry();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(contextEntry)).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        List actualHasTypeRefs = this.context.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.context, hasTypeRef1, hasTypeRef2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.context.getRequiredComponentWidthCount(), (long)this.context.getComponentWidths().size());
        this.context.getComponentWidths().forEach(Assert::assertNull);
    }
}

