/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class InvocationTest {
    private Invocation invocation;

    @Before
    public void setup() {
        this.invocation = (Invocation)Mockito.spy((Object)new Invocation());
    }

    @Test
    public void testGetHasTypeRefs() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        List<Binding> binding = Arrays.asList((Binding)Mockito.mock(Binding.class), (Binding)Mockito.mock(Binding.class));
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Invocation)Mockito.doReturn((Object)expression).when((Object)this.invocation)).getExpression();
        ((Invocation)Mockito.doReturn(binding).when((Object)this.invocation)).getBinding();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)expression)).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(binding)).thenReturn(Arrays.asList(hasTypeRef3, hasTypeRef4));
        List actualHasTypeRefs = this.invocation.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.invocation, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.invocation.getRequiredComponentWidthCount(), (long)this.invocation.getComponentWidths().size());
        this.invocation.getComponentWidths().forEach(Assert::assertNull);
    }
}

