/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;

public class DMNModelInstrumentedBaseTest {
    private static final String DUMMY_PREFIX = "dummy";
    private static final String DUMMY_URI = "http://http://www.kiegroup.org";

    @Test
    public void testParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        child.setParent(parent);
        Assert.assertEquals((Object)((Object)parent), (Object)child.getParent());
    }

    @Test
    public void testGetPrefixForNamespaceURIInheritance() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIOverride() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DUMMY_URI);
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DUMMY_URI);
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentPrefixInChildAndParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.getNsContext().put(DUMMY_PREFIX, DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DUMMY_PREFIX, childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentNothingInChild() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentNothingInParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        child.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertFalse((boolean)parentFeelPrefix.isPresent());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIMultipleNameSpaces() {
        MockDMNModelClass model = new MockDMNModelClass();
        model.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        model.getNsContext().put(DUMMY_PREFIX, DUMMY_URI);
        Optional modelFeelPrefix = model.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)modelFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), modelFeelPrefix.get());
        Optional modelDummyPrefix = model.getPrefixForNamespaceURI(DUMMY_URI);
        Assert.assertTrue((boolean)modelDummyPrefix.isPresent());
        Assert.assertEquals((Object)DUMMY_PREFIX, modelDummyPrefix.get());
    }

    @Test
    public void testNamespaces() {
        List<DMNModelInstrumentedBase.Namespace> namespaces = Arrays.asList(DMNModelInstrumentedBase.Namespace.values());
        Assert.assertEquals((long)7L, (long)namespaces.size());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/FEEL/", (Object)namespaces.get(0).getUri());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/MODEL/", (Object)namespaces.get(1).getUri());
        Assert.assertEquals((Object)"http://www.drools.org/kie/dmn/1.2", (Object)namespaces.get(2).getUri());
        Assert.assertEquals((Object)"https://kiegroup.org/dmn/", (Object)namespaces.get(3).getUri());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/DMNDI/", (Object)namespaces.get(4).getUri());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/DI/", (Object)namespaces.get(5).getUri());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/DC/", (Object)namespaces.get(6).getUri());
        Assert.assertEquals((Object)"feel", (Object)namespaces.get(0).getPrefix());
        Assert.assertEquals((Object)"dmn", (Object)namespaces.get(1).getPrefix());
        Assert.assertEquals((Object)"kie", (Object)namespaces.get(2).getPrefix());
        Assert.assertEquals((Object)"", (Object)namespaces.get(3).getPrefix());
        Assert.assertEquals((Object)"dmndi", (Object)namespaces.get(4).getPrefix());
        Assert.assertEquals((Object)"di", (Object)namespaces.get(5).getPrefix());
        Assert.assertEquals((Object)"dc", (Object)namespaces.get(6).getPrefix());
    }

    public class MockDMNModelClass
    extends DMNModelInstrumentedBase {
    }
}

