/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.dmn.api.definition.DMNDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.stunner.core.definition.builder.Builder;

public abstract class DMNModelInstrumentedBase
implements DMNDefinition {
    private Map<String, String> nsContext = new HashMap<String, String>();
    private Map<QName, String> additionalAttributes = new HashMap<QName, String>();
    private DMNModelInstrumentedBase parent;

    @Override
    public Map<String, String> getNsContext() {
        return this.nsContext;
    }

    public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public Map<QName, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public DMNModelInstrumentedBase getParent() {
        return this.parent;
    }

    public void setParent(DMNModelInstrumentedBase parent) {
        this.parent = parent;
    }

    public Optional<String> getPrefixForNamespaceURI(String namespaceURI) {
        if (this.nsContext != null && this.nsContext.containsValue(namespaceURI)) {
            return this.nsContext.entrySet().stream().filter(kv -> Objects.equals(kv.getValue(), namespaceURI)).findFirst().map(Map.Entry::getKey);
        }
        if (this.parent != null) {
            return this.parent.getPrefixForNamespaceURI(namespaceURI);
        }
        return Optional.empty();
    }

    public String getDefaultNamespace() {
        if (this.nsContext != null && this.nsContext.containsKey("")) {
            return this.nsContext.entrySet().stream().filter(kv -> Objects.equals(kv.getKey(), "")).findFirst().map(Map.Entry::getValue).get();
        }
        if (this.parent != null) {
            return this.parent.getDefaultNamespace();
        }
        return "";
    }

    @NonPortable
    protected static abstract class BaseNodeBuilder<T extends DMNModelInstrumentedBase>
    implements Builder<T> {
        protected BaseNodeBuilder() {
        }
    }

    @Portable
    public static enum Namespace {
        FEEL("feel", "http://www.omg.org/spec/DMN/20180521/FEEL/"),
        DMN("dmn", "http://www.omg.org/spec/DMN/20180521/MODEL/"),
        KIE("kie", "http://www.drools.org/kie/dmn/1.2"),
        DEFAULT("", "https://kiegroup.org/dmn/"),
        DMNDI("dmndi", "http://www.omg.org/spec/DMN/20180521/DMNDI/"),
        DI("di", "http://www.omg.org/spec/DMN/20180521/DI/"),
        DC("dc", "http://www.omg.org/spec/DMN/20180521/DC/");

        private String prefix;
        private String uri;

        private Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

