/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableTest {
    private DecisionTable decisionTable;

    @Before
    public void setup() {
        this.decisionTable = (DecisionTable)Mockito.spy((Object)new DecisionTable());
    }

    @Test
    public void testDefaultHitPolicy() {
        Assert.assertEquals((Object)HitPolicy.UNIQUE, (Object)this.decisionTable.getHitPolicy());
    }

    @Test
    public void testGetHasTypeRefs() {
        InputClause inputClauses1 = (InputClause)Mockito.mock(InputClause.class);
        InputClause inputClauses2 = (InputClause)Mockito.mock(InputClause.class);
        List<InputClause> inputClauses = Arrays.asList(inputClauses1, inputClauses2);
        OutputClause outputClauses1 = (OutputClause)Mockito.mock(OutputClause.class);
        OutputClause outputClauses2 = (OutputClause)Mockito.mock(OutputClause.class);
        List<OutputClause> outputClauses = Arrays.asList(outputClauses1, outputClauses2);
        DecisionRule decisionRules1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule decisionRules2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> decisionRules = Arrays.asList(decisionRules1, decisionRules2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef5 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef6 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((DecisionTable)Mockito.doReturn(inputClauses).when((Object)this.decisionTable)).getInput();
        ((DecisionTable)Mockito.doReturn(outputClauses).when((Object)this.decisionTable)).getOutput();
        ((DecisionTable)Mockito.doReturn(decisionRules).when((Object)this.decisionTable)).getRule();
        PowerMockito.when((Object)inputClauses1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1));
        PowerMockito.when((Object)inputClauses2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef2));
        PowerMockito.when((Object)outputClauses1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef3));
        PowerMockito.when((Object)outputClauses2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef4));
        PowerMockito.when((Object)decisionRules1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef5));
        PowerMockito.when((Object)decisionRules2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef6));
        List actualHasTypeRefs = this.decisionTable.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.decisionTable, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4, hasTypeRef5, hasTypeRef6);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.decisionTable.getRequiredComponentWidthCount(), (long)this.decisionTable.getComponentWidths().size());
        this.decisionTable.getComponentWidths().forEach(Assert::assertNull);
    }
}

